### Summary ####
# Input: df_all_cu_cu and df_f
# Output: Output all regression tables
# Outline: 
# 1. Table III
# 2. Table IV
# 3. Table V
# 4. Table VI
# 5. Table VII
# Note: 
# etable() shows regressions results, 
# DeltaMethod() shows cumulative spending response,
# linearHypothesis() shows joint test results
# Run code out of order can lead to different results
# we recommend once finishing up running all regressions, use only the three commands above
# to obtain results, instead of re-run and obtain results.

#### 0 Preparations ####
setwd(getwd())

## Opening libraries 

library(readr) # for importing datasets
library(dplyr) # for data processing  
library(fixest) # for regressions
library(car) # for aggregating coefficients and standard errors and F-tests
library(skimr) # for summary statistics
library(reldist) # for weighted quantiles

df_f <- read_csv("df_f.csv")

## Labeling observations as treated and untreated 
df_f <- df_f %>% mutate(
  tr_ob = ifelse((EIPII_t>0 | EIPII_tm1 >0 | EIPII_tm2 > 0 | EIPII_tm3 > 0), 1, 0))

# dummies
df_f <- df_f %>% mutate(
  iEIPI_t = ifelse(EIPI_t>0,1,0),
  iEIPI_by_ck_t = ifelse(EIPI_by_ck_t>0,1,0),
  iEIPI_by_dd_t = ifelse(EIPI_by_dd_t>0,1,0),
  iEIPI_by_dc_t = ifelse(EIPI_by_dc_t>0,1,0),
  iEIPI_for_ep_t = ifelse(EIPI_for_ep_t>0,1,0),
  iEIPI_for_debt_t = ifelse(EIPI_for_debt_t>0,1,0),
  iEIPI_for_sv_t = ifelse(EIPI_for_sv_t>0,1,0),
  
  iEIPII_t = ifelse(EIPII_t>0,1,0),
  iEIPII_by_ck_t = ifelse(EIPII_by_ck_t>0,1,0),
  iEIPII_by_dd_t = ifelse(EIPII_by_dd_t>0,1,0),
  iEIPII_by_dc_t = ifelse(EIPII_by_dc_t>0,1,0),
  iEIPII_for_ep_t = ifelse(EIPII_for_ep_t>0,1,0),
  iEIPII_for_debt_t = ifelse(EIPII_for_debt_t>0,1,0),
  iEIPII_for_sv_t = ifelse(EIPII_for_sv_t>0,1,0),
  
  iEIPIII_t = ifelse(EIPIII_t>0,1,0),
  iEIPIII_by_ck_t = ifelse(EIPIII_by_ck_t>0,1,0),
  iEIPIII_by_dd_t = ifelse(EIPIII_by_dd_t>0,1,0),
  iEIPIII_by_dc_t = ifelse(EIPIII_by_dc_t>0,1,0),
  iEIPIII_for_ep_t = ifelse(EIPIII_for_ep_t>0,1,0),
  iEIPIII_for_debt_t = ifelse(EIPIII_for_debt_t>0,1,0),
  iEIPIII_for_sv_t = ifelse(EIPIII_for_sv_t>0,1,0),
  
  iEIPI_tm1 = ifelse(EIPI_tm1>0,1,0),
  iEIPI_by_ck_tm1 = ifelse(EIPI_by_ck_tm1>0,1,0),
  iEIPI_by_dd_tm1 = ifelse(EIPI_by_dd_tm1>0,1,0),
  iEIPI_by_dc_tm1 = ifelse(EIPI_by_dc_tm1>0,1,0),
  iEIPI_for_ep_tm1 = ifelse(EIPI_for_ep_tm1>0,1,0),
  iEIPI_for_debt_tm1 = ifelse(EIPI_for_debt_tm1>0,1,0),
  iEIPI_for_sv_tm1 = ifelse(EIPI_for_sv_tm1>0,1,0),
  
  iEIPII_tm1 = ifelse(EIPII_tm1>0,1,0),
  iEIPII_by_ck_tm1 = ifelse(EIPII_by_ck_tm1>0,1,0),
  iEIPII_by_dd_tm1 = ifelse(EIPII_by_dd_tm1>0,1,0),
  iEIPII_by_dc_tm1 = ifelse(EIPII_by_dc_tm1>0,1,0),
  iEIPII_for_ep_tm1 = ifelse(EIPII_for_ep_tm1>0,1,0),
  iEIPII_for_debt_tm1 = ifelse(EIPII_for_debt_tm1>0,1,0),
  iEIPII_for_sv_tm1 = ifelse(EIPII_for_sv_tm1>0,1,0),
  
  iEIPIII_tm1 = ifelse(EIPIII_tm1>0,1,0),
  iEIPIII_by_ck_tm1 = ifelse(EIPIII_by_ck_tm1>0,1,0),
  iEIPIII_by_dd_tm1 = ifelse(EIPIII_by_dd_tm1>0,1,0),
  iEIPIII_by_dc_tm1 = ifelse(EIPIII_by_dc_tm1>0,1,0),
  iEIPIII_for_ep_tm1 = ifelse(EIPIII_for_ep_tm1>0,1,0),
  iEIPIII_for_debt_tm1 = ifelse(EIPIII_for_debt_tm1>0,1,0),
  iEIPIII_for_sv_tm1 = ifelse(EIPIII_for_sv_tm1>0,1,0)
  
)

# Scaling 
## Food ##
df_f_sc_fd <- df_f

df_f_sc_fd <- df_f_sc_fd %>% mutate(
  s_d_EX_FD_t = d_EX_FD_t / EX_FD_AVG,
  Y = s_d_EX_FD_t,
  s_AGE_AVG_t = AGE_AVG_t / EX_FD_AVG,
  s_d_NUM_ADTS_t = d_NUM_ADTS_t / EX_FD_AVG,
  s_d_NUM_KIDS_t = d_NUM_KIDS_t / EX_FD_AVG,
  
  s_EIPI_t = EIPI_t / EX_FD_AVG,
  s_EIPI_tm1 = EIPI_tm1 / EX_FD_AVG,
  s_iEIPI_t = iEIPI_t / EX_FD_AVG,
  s_iEIPI_tm1 = iEIPI_tm1 / EX_FD_AVG,
  
  s_EIPI_by_ck_t = EIPI_by_ck_t / EX_FD_AVG,
  s_EIPI_by_dd_t = EIPI_by_dd_t/ EX_FD_AVG,
  s_EIPI_by_dc_t = EIPI_by_dc_t / EX_FD_AVG,
  s_EIPI_for_ep_t = EIPI_for_ep_t / EX_FD_AVG,
  s_EIPI_for_debt_t = EIPI_for_debt_t / EX_FD_AVG,
  s_EIPI_for_sv_t = EIPI_for_sv_t / EX_FD_AVG,
  
  s_iEIPI_by_ck_t = iEIPI_by_ck_t / EX_FD_AVG,
  s_iEIPI_by_dd_t = iEIPI_by_dd_t / EX_FD_AVG,
  s_iEIPI_by_dc_t = iEIPI_by_dc_t / EX_FD_AVG,
  s_iEIPI_for_ep_t = iEIPI_for_ep_t / EX_FD_AVG,
  s_iEIPI_for_debt_t = iEIPI_for_debt_t / EX_FD_AVG,
  s_iEIPI_for_sv_t = iEIPI_for_sv_t / EX_FD_AVG,
  
  s_EIPI_by_ck_tm1 = EIPI_by_ck_tm1 / EX_FD_AVG,
  s_EIPI_by_dd_tm1 = EIPI_by_dd_tm1/ EX_FD_AVG,
  s_EIPI_by_dc_tm1 = EIPI_by_dc_tm1 / EX_FD_AVG,
  s_EIPI_for_ep_tm1 = EIPI_for_ep_tm1 / EX_FD_AVG,
  s_EIPI_for_debt_tm1 = EIPI_for_debt_tm1 / EX_FD_AVG,
  s_EIPI_for_sv_tm1 = EIPI_for_sv_tm1 / EX_FD_AVG,
  
  s_iEIPI_by_ck_tm1 = iEIPI_by_ck_tm1 / EX_FD_AVG,
  s_iEIPI_by_dd_tm1 = iEIPI_by_dd_tm1/ EX_FD_AVG,
  s_iEIPI_by_dc_tm1 = iEIPI_by_dc_tm1 / EX_FD_AVG,
  s_iEIPI_for_ep_tm1 = iEIPI_for_ep_tm1 / EX_FD_AVG,
  s_iEIPI_for_debt_tm1 = iEIPI_for_debt_tm1 / EX_FD_AVG,
  s_iEIPI_for_sv_tm1 = iEIPI_for_sv_tm1 / EX_FD_AVG,
  
  s_EIPII_t = EIPII_t / EX_FD_AVG,
  s_EIPII_tm1 = EIPII_tm1 / EX_FD_AVG,
  s_iEIPII_t = iEIPII_t / EX_FD_AVG,
  s_iEIPII_tm1 = iEIPII_tm1 / EX_FD_AVG,
  
  s_EIPII_by_ck_t = EIPII_by_ck_t / EX_FD_AVG,
  s_EIPII_by_dd_t = EIPII_by_dd_t/ EX_FD_AVG,
  s_EIPII_by_dc_t = EIPII_by_dc_t / EX_FD_AVG,
  s_EIPII_for_ep_t = EIPII_for_ep_t / EX_FD_AVG,
  s_EIPII_for_debt_t = EIPII_for_debt_t / EX_FD_AVG,
  s_EIPII_for_sv_t = EIPII_for_sv_t / EX_FD_AVG,
  
  s_iEIPII_by_ck_t = iEIPII_by_ck_t / EX_FD_AVG,
  s_iEIPII_by_dd_t = iEIPII_by_dd_t / EX_FD_AVG,
  s_iEIPII_by_dc_t = iEIPII_by_dc_t / EX_FD_AVG,
  s_iEIPII_for_ep_t = iEIPII_for_ep_t / EX_FD_AVG,
  s_iEIPII_for_debt_t = iEIPII_for_debt_t / EX_FD_AVG,
  s_iEIPII_for_sv_t = iEIPII_for_sv_t / EX_FD_AVG,
  
  s_EIPII_by_ck_tm1 = EIPII_by_ck_tm1 / EX_FD_AVG,
  s_EIPII_by_dd_tm1 = EIPII_by_dd_tm1/ EX_FD_AVG,
  s_EIPII_by_dc_tm1 = EIPII_by_dc_tm1 / EX_FD_AVG,
  s_EIPII_for_ep_tm1 = EIPII_for_ep_tm1 / EX_FD_AVG,
  s_EIPII_for_debt_tm1 = EIPII_for_debt_tm1 / EX_FD_AVG,
  s_EIPII_for_sv_tm1 = EIPII_for_sv_tm1 / EX_FD_AVG,
  
  s_iEIPII_by_ck_tm1 = iEIPII_by_ck_tm1 / EX_FD_AVG,
  s_iEIPII_by_dd_tm1 = iEIPII_by_dd_tm1/ EX_FD_AVG,
  s_iEIPII_by_dc_tm1 = iEIPII_by_dc_tm1 / EX_FD_AVG,
  s_iEIPII_for_ep_tm1 = iEIPII_for_ep_tm1 / EX_FD_AVG,
  s_iEIPII_for_debt_tm1 = iEIPII_for_debt_tm1 / EX_FD_AVG,
  s_iEIPII_for_sv_tm1 = iEIPII_for_sv_tm1 / EX_FD_AVG,
  
  s_EIPIII_t = EIPIII_t / EX_FD_AVG,
  s_EIPIII_tm1 = EIPIII_tm1 / EX_FD_AVG,
  s_iEIPIII_t = iEIPIII_t / EX_FD_AVG,
  s_iEIPIII_tm1 = iEIPIII_tm1 / EX_FD_AVG,
  
  s_EIPIII_by_ck_t = EIPIII_by_ck_t / EX_FD_AVG,
  s_EIPIII_by_dd_t = EIPIII_by_dd_t/ EX_FD_AVG,
  s_EIPIII_by_dc_t = EIPIII_by_dc_t / EX_FD_AVG,
  s_EIPIII_for_ep_t = EIPIII_for_ep_t / EX_FD_AVG,
  s_EIPIII_for_debt_t = EIPIII_for_debt_t / EX_FD_AVG,
  s_EIPIII_for_sv_t = EIPIII_for_sv_t / EX_FD_AVG,
  
  s_iEIPIII_by_ck_t = iEIPIII_by_ck_t / EX_FD_AVG,
  s_iEIPIII_by_dd_t = iEIPIII_by_dd_t / EX_FD_AVG,
  s_iEIPIII_by_dc_t = iEIPIII_by_dc_t / EX_FD_AVG,
  s_iEIPIII_for_ep_t = iEIPIII_for_ep_t / EX_FD_AVG,
  s_iEIPIII_for_debt_t = iEIPIII_for_debt_t / EX_FD_AVG,
  s_iEIPIII_for_sv_t = iEIPIII_for_sv_t / EX_FD_AVG,
  
  s_EIPIII_by_ck_tm1 = EIPIII_by_ck_tm1 / EX_FD_AVG,
  s_EIPIII_by_dd_tm1 = EIPIII_by_dd_tm1/ EX_FD_AVG,
  s_EIPIII_by_dc_tm1 = EIPIII_by_dc_tm1 / EX_FD_AVG,
  s_EIPIII_for_ep_tm1 = EIPIII_for_ep_tm1 / EX_FD_AVG,
  s_EIPIII_for_debt_tm1 = EIPIII_for_debt_tm1 / EX_FD_AVG,
  s_EIPIII_for_sv_tm1 = EIPIII_for_sv_tm1 / EX_FD_AVG,
  
  s_iEIPIII_by_ck_tm1 = iEIPIII_by_ck_tm1 / EX_FD_AVG,
  s_iEIPIII_by_dd_tm1 = iEIPIII_by_dd_tm1/ EX_FD_AVG,
  s_iEIPIII_by_dc_tm1 = iEIPIII_by_dc_tm1 / EX_FD_AVG,
  s_iEIPIII_for_ep_tm1 = iEIPIII_for_ep_tm1 / EX_FD_AVG,
  s_iEIPIII_for_debt_tm1 = iEIPIII_for_debt_tm1 / EX_FD_AVG,
  s_iEIPIII_for_sv_tm1 = iEIPIII_for_sv_tm1 / EX_FD_AVG )

# Drop outliers 440798
df_f_sc_fd <- df_f_sc_fd %>% filter(ID!=440798)

# Scaling 
## Strict non-durabls ##
df_f_sc_sn <- df_f

df_f_sc_sn <- df_f_sc_sn %>% mutate(
  s_d_EX_SN_t = d_EX_SN_t / EX_SN_AVG ,
  Y = s_d_EX_SN_t ,
  s_AGE_AVG_t = AGE_AVG_t / EX_SN_AVG ,
  s_d_NUM_ADTS_t = d_NUM_ADTS_t / EX_SN_AVG ,
  s_d_NUM_KIDS_t = d_NUM_KIDS_t / EX_SN_AVG ,
  
  s_EIPI_t = EIPI_t / EX_SN_AVG ,
  s_EIPI_tm1 = EIPI_tm1 / EX_SN_AVG ,
  s_iEIPI_t = iEIPI_t / EX_SN_AVG ,
  s_iEIPI_tm1 = iEIPI_tm1 / EX_SN_AVG ,
  
  s_EIPI_by_ck_t = EIPI_by_ck_t / EX_SN_AVG ,
  s_EIPI_by_dd_t = EIPI_by_dd_t/ EX_SN_AVG ,
  s_EIPI_by_dc_t = EIPI_by_dc_t / EX_SN_AVG ,
  s_EIPI_for_ep_t = EIPI_for_ep_t / EX_SN_AVG ,
  s_EIPI_for_debt_t = EIPI_for_debt_t / EX_SN_AVG ,
  s_EIPI_for_sv_t = EIPI_for_sv_t / EX_SN_AVG ,
  
  s_iEIPI_by_ck_t = iEIPI_by_ck_t / EX_SN_AVG ,
  s_iEIPI_by_dd_t = iEIPI_by_dd_t / EX_SN_AVG ,
  s_iEIPI_by_dc_t = iEIPI_by_dc_t / EX_SN_AVG ,
  s_iEIPI_for_ep_t = iEIPI_for_ep_t / EX_SN_AVG ,
  s_iEIPI_for_debt_t = iEIPI_for_debt_t / EX_SN_AVG ,
  s_iEIPI_for_sv_t = iEIPI_for_sv_t / EX_SN_AVG ,
  
  s_EIPI_by_ck_tm1 = EIPI_by_ck_tm1 / EX_SN_AVG ,
  s_EIPI_by_dd_tm1 = EIPI_by_dd_tm1/ EX_SN_AVG ,
  s_EIPI_by_dc_tm1 = EIPI_by_dc_tm1 / EX_SN_AVG ,
  s_EIPI_for_ep_tm1 = EIPI_for_ep_tm1 / EX_SN_AVG ,
  s_EIPI_for_debt_tm1 = EIPI_for_debt_tm1 / EX_SN_AVG ,
  s_EIPI_for_sv_tm1 = EIPI_for_sv_tm1 / EX_SN_AVG ,
  
  s_iEIPI_by_ck_tm1 = iEIPI_by_ck_tm1 / EX_SN_AVG ,
  s_iEIPI_by_dd_tm1 = iEIPI_by_dd_tm1/ EX_SN_AVG ,
  s_iEIPI_by_dc_tm1 = iEIPI_by_dc_tm1 / EX_SN_AVG ,
  s_iEIPI_for_ep_tm1 = iEIPI_for_ep_tm1 / EX_SN_AVG ,
  s_iEIPI_for_debt_tm1 = iEIPI_for_debt_tm1 / EX_SN_AVG ,
  s_iEIPI_for_sv_tm1 = iEIPI_for_sv_tm1 / EX_SN_AVG ,
  
  s_EIPII_t = EIPII_t / EX_SN_AVG ,
  s_EIPII_tm1 = EIPII_tm1 / EX_SN_AVG ,
  s_iEIPII_t = iEIPII_t / EX_SN_AVG ,
  s_iEIPII_tm1 = iEIPII_tm1 / EX_SN_AVG ,
  
  s_EIPII_by_ck_t = EIPII_by_ck_t / EX_SN_AVG ,
  s_EIPII_by_dd_t = EIPII_by_dd_t/ EX_SN_AVG ,
  s_EIPII_by_dc_t = EIPII_by_dc_t / EX_SN_AVG ,
  s_EIPII_for_ep_t = EIPII_for_ep_t / EX_SN_AVG ,
  s_EIPII_for_debt_t = EIPII_for_debt_t / EX_SN_AVG ,
  s_EIPII_for_sv_t = EIPII_for_sv_t / EX_SN_AVG ,
  
  s_iEIPII_by_ck_t = iEIPII_by_ck_t / EX_SN_AVG ,
  s_iEIPII_by_dd_t = iEIPII_by_dd_t / EX_SN_AVG ,
  s_iEIPII_by_dc_t = iEIPII_by_dc_t / EX_SN_AVG ,
  s_iEIPII_for_ep_t = iEIPII_for_ep_t / EX_SN_AVG ,
  s_iEIPII_for_debt_t = iEIPII_for_debt_t / EX_SN_AVG ,
  s_iEIPII_for_sv_t = iEIPII_for_sv_t / EX_SN_AVG ,
  
  s_EIPII_by_ck_tm1 = EIPII_by_ck_tm1 / EX_SN_AVG ,
  s_EIPII_by_dd_tm1 = EIPII_by_dd_tm1/ EX_SN_AVG ,
  s_EIPII_by_dc_tm1 = EIPII_by_dc_tm1 / EX_SN_AVG ,
  s_EIPII_for_ep_tm1 = EIPII_for_ep_tm1 / EX_SN_AVG ,
  s_EIPII_for_debt_tm1 = EIPII_for_debt_tm1 / EX_SN_AVG ,
  s_EIPII_for_sv_tm1 = EIPII_for_sv_tm1 / EX_SN_AVG ,
  
  s_iEIPII_by_ck_tm1 = iEIPII_by_ck_tm1 / EX_SN_AVG ,
  s_iEIPII_by_dd_tm1 = iEIPII_by_dd_tm1/ EX_SN_AVG ,
  s_iEIPII_by_dc_tm1 = iEIPII_by_dc_tm1 / EX_SN_AVG ,
  s_iEIPII_for_ep_tm1 = iEIPII_for_ep_tm1 / EX_SN_AVG ,
  s_iEIPII_for_debt_tm1 = iEIPII_for_debt_tm1 / EX_SN_AVG ,
  s_iEIPII_for_sv_tm1 = iEIPII_for_sv_tm1 / EX_SN_AVG ,
  
  s_EIPIII_t = EIPIII_t / EX_SN_AVG ,
  s_EIPIII_tm1 = EIPIII_tm1 / EX_SN_AVG ,
  s_iEIPIII_t = iEIPIII_t / EX_SN_AVG ,
  s_iEIPIII_tm1 = iEIPIII_tm1 / EX_SN_AVG ,
  
  s_EIPIII_by_ck_t = EIPIII_by_ck_t / EX_SN_AVG ,
  s_EIPIII_by_dd_t = EIPIII_by_dd_t/ EX_SN_AVG ,
  s_EIPIII_by_dc_t = EIPIII_by_dc_t / EX_SN_AVG ,
  s_EIPIII_for_ep_t = EIPIII_for_ep_t / EX_SN_AVG ,
  s_EIPIII_for_debt_t = EIPIII_for_debt_t / EX_SN_AVG ,
  s_EIPIII_for_sv_t = EIPIII_for_sv_t / EX_SN_AVG ,
  
  s_iEIPIII_by_ck_t = iEIPIII_by_ck_t / EX_SN_AVG ,
  s_iEIPIII_by_dd_t = iEIPIII_by_dd_t / EX_SN_AVG ,
  s_iEIPIII_by_dc_t = iEIPIII_by_dc_t / EX_SN_AVG ,
  s_iEIPIII_for_ep_t = iEIPIII_for_ep_t / EX_SN_AVG ,
  s_iEIPIII_for_debt_t = iEIPIII_for_debt_t / EX_SN_AVG ,
  s_iEIPIII_for_sv_t = iEIPIII_for_sv_t / EX_SN_AVG ,
  
  s_EIPIII_by_ck_tm1 = EIPIII_by_ck_tm1 / EX_SN_AVG ,
  s_EIPIII_by_dd_tm1 = EIPIII_by_dd_tm1/ EX_SN_AVG ,
  s_EIPIII_by_dc_tm1 = EIPIII_by_dc_tm1 / EX_SN_AVG ,
  s_EIPIII_for_ep_tm1 = EIPIII_for_ep_tm1 / EX_SN_AVG ,
  s_EIPIII_for_debt_tm1 = EIPIII_for_debt_tm1 / EX_SN_AVG ,
  s_EIPIII_for_sv_tm1 = EIPIII_for_sv_tm1 / EX_SN_AVG ,
  
  s_iEIPIII_by_ck_tm1 = iEIPIII_by_ck_tm1 / EX_SN_AVG ,
  s_iEIPIII_by_dd_tm1 = iEIPIII_by_dd_tm1/ EX_SN_AVG ,
  s_iEIPIII_by_dc_tm1 = iEIPIII_by_dc_tm1 / EX_SN_AVG ,
  s_iEIPIII_for_ep_tm1 = iEIPIII_for_ep_tm1 / EX_SN_AVG ,
  s_iEIPIII_for_debt_tm1 = iEIPIII_for_debt_tm1 / EX_SN_AVG ,
  s_iEIPIII_for_sv_tm1 = iEIPIII_for_sv_tm1 / EX_SN_AVG )

# Drop outliers 441555, 465865, and 466269
df_f_sc_sn <- df_f_sc_sn %>% filter(ID!=441555 & ID!=465865 & ID!=466269)

# Scaling 
## Non-durabls ##
df_f_sc_n <- df_f

df_f_sc_n <- df_f_sc_n %>% mutate(
  s_d_EX_N_t = d_EX_N_t / EX_N_AVG,
  Y = s_d_EX_N_t,
  s_AGE_AVG_t = AGE_AVG_t / EX_N_AVG,
  s_d_NUM_ADTS_t = d_NUM_ADTS_t / EX_N_AVG,
  s_d_NUM_KIDS_t = d_NUM_KIDS_t / EX_N_AVG,
  
  s_EIPI_t = EIPI_t / EX_N_AVG,
  s_EIPI_tm1 = EIPI_tm1 / EX_N_AVG,
  s_iEIPI_t = iEIPI_t / EX_N_AVG,
  s_iEIPI_tm1 = iEIPI_tm1 / EX_N_AVG,
  
  s_EIPI_by_ck_t = EIPI_by_ck_t / EX_N_AVG,
  s_EIPI_by_dd_t = EIPI_by_dd_t/ EX_N_AVG,
  s_EIPI_by_dc_t = EIPI_by_dc_t / EX_N_AVG,
  s_EIPI_for_ep_t = EIPI_for_ep_t / EX_N_AVG,
  s_EIPI_for_debt_t = EIPI_for_debt_t / EX_N_AVG,
  s_EIPI_for_sv_t = EIPI_for_sv_t / EX_N_AVG,
  
  s_iEIPI_by_ck_t = iEIPI_by_ck_t / EX_N_AVG,
  s_iEIPI_by_dd_t = iEIPI_by_dd_t / EX_N_AVG,
  s_iEIPI_by_dc_t = iEIPI_by_dc_t / EX_N_AVG,
  s_iEIPI_for_ep_t = iEIPI_for_ep_t / EX_N_AVG,
  s_iEIPI_for_debt_t = iEIPI_for_debt_t / EX_N_AVG,
  s_iEIPI_for_sv_t = iEIPI_for_sv_t / EX_N_AVG,
  
  s_EIPI_by_ck_tm1 = EIPI_by_ck_tm1 / EX_N_AVG,
  s_EIPI_by_dd_tm1 = EIPI_by_dd_tm1/ EX_N_AVG,
  s_EIPI_by_dc_tm1 = EIPI_by_dc_tm1 / EX_N_AVG,
  s_EIPI_for_ep_tm1 = EIPI_for_ep_tm1 / EX_N_AVG,
  s_EIPI_for_debt_tm1 = EIPI_for_debt_tm1 / EX_N_AVG,
  s_EIPI_for_sv_tm1 = EIPI_for_sv_tm1 / EX_N_AVG,
  
  s_iEIPI_by_ck_tm1 = iEIPI_by_ck_tm1 / EX_N_AVG,
  s_iEIPI_by_dd_tm1 = iEIPI_by_dd_tm1/ EX_N_AVG,
  s_iEIPI_by_dc_tm1 = iEIPI_by_dc_tm1 / EX_N_AVG,
  s_iEIPI_for_ep_tm1 = iEIPI_for_ep_tm1 / EX_N_AVG,
  s_iEIPI_for_debt_tm1 = iEIPI_for_debt_tm1 / EX_N_AVG,
  s_iEIPI_for_sv_tm1 = iEIPI_for_sv_tm1 / EX_N_AVG,
  
  s_EIPII_t = EIPII_t / EX_N_AVG,
  s_EIPII_tm1 = EIPII_tm1 / EX_N_AVG,
  s_iEIPII_t = iEIPII_t / EX_N_AVG,
  s_iEIPII_tm1 = iEIPII_tm1 / EX_N_AVG,
  
  s_EIPII_by_ck_t = EIPII_by_ck_t / EX_N_AVG,
  s_EIPII_by_dd_t = EIPII_by_dd_t/ EX_N_AVG,
  s_EIPII_by_dc_t = EIPII_by_dc_t / EX_N_AVG,
  s_EIPII_for_ep_t = EIPII_for_ep_t / EX_N_AVG,
  s_EIPII_for_debt_t = EIPII_for_debt_t / EX_N_AVG,
  s_EIPII_for_sv_t = EIPII_for_sv_t / EX_N_AVG,
  
  s_iEIPII_by_ck_t = iEIPII_by_ck_t / EX_N_AVG,
  s_iEIPII_by_dd_t = iEIPII_by_dd_t / EX_N_AVG,
  s_iEIPII_by_dc_t = iEIPII_by_dc_t / EX_N_AVG,
  s_iEIPII_for_ep_t = iEIPII_for_ep_t / EX_N_AVG,
  s_iEIPII_for_debt_t = iEIPII_for_debt_t / EX_N_AVG,
  s_iEIPII_for_sv_t = iEIPII_for_sv_t / EX_N_AVG,
  
  s_EIPII_by_ck_tm1 = EIPII_by_ck_tm1 / EX_N_AVG,
  s_EIPII_by_dd_tm1 = EIPII_by_dd_tm1/ EX_N_AVG,
  s_EIPII_by_dc_tm1 = EIPII_by_dc_tm1 / EX_N_AVG,
  s_EIPII_for_ep_tm1 = EIPII_for_ep_tm1 / EX_N_AVG,
  s_EIPII_for_debt_tm1 = EIPII_for_debt_tm1 / EX_N_AVG,
  s_EIPII_for_sv_tm1 = EIPII_for_sv_tm1 / EX_N_AVG,
  
  s_iEIPII_by_ck_tm1 = iEIPII_by_ck_tm1 / EX_N_AVG,
  s_iEIPII_by_dd_tm1 = iEIPII_by_dd_tm1/ EX_N_AVG,
  s_iEIPII_by_dc_tm1 = iEIPII_by_dc_tm1 / EX_N_AVG,
  s_iEIPII_for_ep_tm1 = iEIPII_for_ep_tm1 / EX_N_AVG,
  s_iEIPII_for_debt_tm1 = iEIPII_for_debt_tm1 / EX_N_AVG,
  s_iEIPII_for_sv_tm1 = iEIPII_for_sv_tm1 / EX_N_AVG,
  
  s_EIPIII_t = EIPIII_t / EX_N_AVG,
  s_EIPIII_tm1 = EIPIII_tm1 / EX_N_AVG,
  s_iEIPIII_t = iEIPIII_t / EX_N_AVG,
  s_iEIPIII_tm1 = iEIPIII_tm1 / EX_N_AVG,
  
  s_EIPIII_by_ck_t = EIPIII_by_ck_t / EX_N_AVG,
  s_EIPIII_by_dd_t = EIPIII_by_dd_t/ EX_N_AVG,
  s_EIPIII_by_dc_t = EIPIII_by_dc_t / EX_N_AVG,
  s_EIPIII_for_ep_t = EIPIII_for_ep_t / EX_N_AVG,
  s_EIPIII_for_debt_t = EIPIII_for_debt_t / EX_N_AVG,
  s_EIPIII_for_sv_t = EIPIII_for_sv_t / EX_N_AVG,
  
  s_iEIPIII_by_ck_t = iEIPIII_by_ck_t / EX_N_AVG,
  s_iEIPIII_by_dd_t = iEIPIII_by_dd_t / EX_N_AVG,
  s_iEIPIII_by_dc_t = iEIPIII_by_dc_t / EX_N_AVG,
  s_iEIPIII_for_ep_t = iEIPIII_for_ep_t / EX_N_AVG,
  s_iEIPIII_for_debt_t = iEIPIII_for_debt_t / EX_N_AVG,
  s_iEIPIII_for_sv_t = iEIPIII_for_sv_t / EX_N_AVG,
  
  s_EIPIII_by_ck_tm1 = EIPIII_by_ck_tm1 / EX_N_AVG,
  s_EIPIII_by_dd_tm1 = EIPIII_by_dd_tm1/ EX_N_AVG,
  s_EIPIII_by_dc_tm1 = EIPIII_by_dc_tm1 / EX_N_AVG,
  s_EIPIII_for_ep_tm1 = EIPIII_for_ep_tm1 / EX_N_AVG,
  s_EIPIII_for_debt_tm1 = EIPIII_for_debt_tm1 / EX_N_AVG,
  s_EIPIII_for_sv_tm1 = EIPIII_for_sv_tm1 / EX_N_AVG,
  
  s_iEIPIII_by_ck_tm1 = iEIPIII_by_ck_tm1 / EX_N_AVG,
  s_iEIPIII_by_dd_tm1 = iEIPIII_by_dd_tm1/ EX_N_AVG,
  s_iEIPIII_by_dc_tm1 = iEIPIII_by_dc_tm1 / EX_N_AVG,
  s_iEIPIII_for_ep_tm1 = iEIPIII_for_ep_tm1 / EX_N_AVG,
  s_iEIPIII_for_debt_tm1 = iEIPIII_for_debt_tm1 / EX_N_AVG,
  s_iEIPIII_for_sv_tm1 = iEIPIII_for_sv_tm1 / EX_N_AVG)

# Drop outliers 441555
df_f_sc_n <- df_f_sc_n %>% filter(ID!=441555)

# Scaling 
## Total expenditure ##
df_f_sc_t <- df_f

df_f_sc_t <- df_f_sc_t %>% mutate(
  s_d_EX_T_t = d_EX_T_t / EX_T_AVG,
  Y = s_d_EX_T_t,
  s_AGE_AVG_t = AGE_AVG_t / EX_T_AVG,
  s_d_NUM_ADTS_t = d_NUM_ADTS_t / EX_T_AVG,
  s_d_NUM_KIDS_t = d_NUM_KIDS_t / EX_T_AVG,
  
  s_EIPI_t = EIPI_t / EX_T_AVG,
  s_EIPI_tm1 = EIPI_tm1 / EX_T_AVG,
  s_iEIPI_t = iEIPI_t / EX_T_AVG,
  s_iEIPI_tm1 = iEIPI_tm1 / EX_T_AVG,
  
  s_EIPI_by_ck_t = EIPI_by_ck_t / EX_T_AVG,
  s_EIPI_by_dd_t = EIPI_by_dd_t/ EX_T_AVG,
  s_EIPI_by_dc_t = EIPI_by_dc_t / EX_T_AVG,
  s_EIPI_for_ep_t = EIPI_for_ep_t / EX_T_AVG,
  s_EIPI_for_debt_t = EIPI_for_debt_t / EX_T_AVG,
  s_EIPI_for_sv_t = EIPI_for_sv_t / EX_T_AVG,
  
  s_iEIPI_by_ck_t = iEIPI_by_ck_t / EX_T_AVG,
  s_iEIPI_by_dd_t = iEIPI_by_dd_t / EX_T_AVG,
  s_iEIPI_by_dc_t = iEIPI_by_dc_t / EX_T_AVG,
  s_iEIPI_for_ep_t = iEIPI_for_ep_t / EX_T_AVG,
  s_iEIPI_for_debt_t = iEIPI_for_debt_t / EX_T_AVG,
  s_iEIPI_for_sv_t = iEIPI_for_sv_t / EX_T_AVG,
  
  s_EIPI_by_ck_tm1 = EIPI_by_ck_tm1 / EX_T_AVG,
  s_EIPI_by_dd_tm1 = EIPI_by_dd_tm1/ EX_T_AVG,
  s_EIPI_by_dc_tm1 = EIPI_by_dc_tm1 / EX_T_AVG,
  s_EIPI_for_ep_tm1 = EIPI_for_ep_tm1 / EX_T_AVG,
  s_EIPI_for_debt_tm1 = EIPI_for_debt_tm1 / EX_T_AVG,
  s_EIPI_for_sv_tm1 = EIPI_for_sv_tm1 / EX_T_AVG,
  
  s_iEIPI_by_ck_tm1 = iEIPI_by_ck_tm1 / EX_T_AVG,
  s_iEIPI_by_dd_tm1 = iEIPI_by_dd_tm1/ EX_T_AVG,
  s_iEIPI_by_dc_tm1 = iEIPI_by_dc_tm1 / EX_T_AVG,
  s_iEIPI_for_ep_tm1 = iEIPI_for_ep_tm1 / EX_T_AVG,
  s_iEIPI_for_debt_tm1 = iEIPI_for_debt_tm1 / EX_T_AVG,
  s_iEIPI_for_sv_tm1 = iEIPI_for_sv_tm1 / EX_T_AVG, 
  
  s_EIPII_t = EIPII_t / EX_T_AVG,
  s_EIPII_tm1 = EIPII_tm1 / EX_T_AVG,
  s_iEIPII_t = iEIPII_t / EX_T_AVG,
  s_iEIPII_tm1 = iEIPII_tm1 / EX_T_AVG,
  
  s_EIPII_by_ck_t = EIPII_by_ck_t / EX_T_AVG,
  s_EIPII_by_dd_t = EIPII_by_dd_t/ EX_T_AVG,
  s_EIPII_by_dc_t = EIPII_by_dc_t / EX_T_AVG,
  s_EIPII_for_ep_t = EIPII_for_ep_t / EX_T_AVG,
  s_EIPII_for_debt_t = EIPII_for_debt_t / EX_T_AVG,
  s_EIPII_for_sv_t = EIPII_for_sv_t / EX_T_AVG,
  
  s_iEIPII_by_ck_t = iEIPII_by_ck_t / EX_T_AVG,
  s_iEIPII_by_dd_t = iEIPII_by_dd_t / EX_T_AVG,
  s_iEIPII_by_dc_t = iEIPII_by_dc_t / EX_T_AVG,
  s_iEIPII_for_ep_t = iEIPII_for_ep_t / EX_T_AVG,
  s_iEIPII_for_debt_t = iEIPII_for_debt_t / EX_T_AVG,
  s_iEIPII_for_sv_t = iEIPII_for_sv_t / EX_T_AVG,
  
  s_EIPII_by_ck_tm1 = EIPII_by_ck_tm1 / EX_T_AVG,
  s_EIPII_by_dd_tm1 = EIPII_by_dd_tm1/ EX_T_AVG,
  s_EIPII_by_dc_tm1 = EIPII_by_dc_tm1 / EX_T_AVG,
  s_EIPII_for_ep_tm1 = EIPII_for_ep_tm1 / EX_T_AVG,
  s_EIPII_for_debt_tm1 = EIPII_for_debt_tm1 / EX_T_AVG,
  s_EIPII_for_sv_tm1 = EIPII_for_sv_tm1 / EX_T_AVG,
  
  s_iEIPII_by_ck_tm1 = iEIPII_by_ck_tm1 / EX_T_AVG,
  s_iEIPII_by_dd_tm1 = iEIPII_by_dd_tm1/ EX_T_AVG,
  s_iEIPII_by_dc_tm1 = iEIPII_by_dc_tm1 / EX_T_AVG,
  s_iEIPII_for_ep_tm1 = iEIPII_for_ep_tm1 / EX_T_AVG,
  s_iEIPII_for_debt_tm1 = iEIPII_for_debt_tm1 / EX_T_AVG,
  s_iEIPII_for_sv_tm1 = iEIPII_for_sv_tm1 / EX_T_AVG, 
  
  s_EIPIII_t = EIPIII_t / EX_T_AVG,
  s_EIPIII_tm1 = EIPIII_tm1 / EX_T_AVG,
  s_iEIPIII_t = iEIPIII_t / EX_T_AVG,
  s_iEIPIII_tm1 = iEIPIII_tm1 / EX_T_AVG,
  
  s_EIPIII_by_ck_t = EIPIII_by_ck_t / EX_T_AVG,
  s_EIPIII_by_dd_t = EIPIII_by_dd_t/ EX_T_AVG,
  s_EIPIII_by_dc_t = EIPIII_by_dc_t / EX_T_AVG,
  s_EIPIII_for_ep_t = EIPIII_for_ep_t / EX_T_AVG,
  s_EIPIII_for_debt_t = EIPIII_for_debt_t / EX_T_AVG,
  s_EIPIII_for_sv_t = EIPIII_for_sv_t / EX_T_AVG,
  
  s_iEIPIII_by_ck_t = iEIPIII_by_ck_t / EX_T_AVG,
  s_iEIPIII_by_dd_t = iEIPIII_by_dd_t / EX_T_AVG,
  s_iEIPIII_by_dc_t = iEIPIII_by_dc_t / EX_T_AVG,
  s_iEIPIII_for_ep_t = iEIPIII_for_ep_t / EX_T_AVG,
  s_iEIPIII_for_debt_t = iEIPIII_for_debt_t / EX_T_AVG,
  s_iEIPIII_for_sv_t = iEIPIII_for_sv_t / EX_T_AVG,
  
  s_EIPIII_by_ck_tm1 = EIPIII_by_ck_tm1 / EX_T_AVG,
  s_EIPIII_by_dd_tm1 = EIPIII_by_dd_tm1/ EX_T_AVG,
  s_EIPIII_by_dc_tm1 = EIPIII_by_dc_tm1 / EX_T_AVG,
  s_EIPIII_for_ep_tm1 = EIPIII_for_ep_tm1 / EX_T_AVG,
  s_EIPIII_for_debt_tm1 = EIPIII_for_debt_tm1 / EX_T_AVG,
  s_EIPIII_for_sv_tm1 = EIPIII_for_sv_tm1 / EX_T_AVG,
  
  s_iEIPIII_by_ck_tm1 = iEIPIII_by_ck_tm1 / EX_T_AVG,
  s_iEIPIII_by_dd_tm1 = iEIPIII_by_dd_tm1/ EX_T_AVG,
  s_iEIPIII_by_dc_tm1 = iEIPIII_by_dc_tm1 / EX_T_AVG,
  s_iEIPIII_for_ep_tm1 = iEIPIII_for_ep_tm1 / EX_T_AVG,
  s_iEIPIII_for_debt_tm1 = iEIPIII_for_debt_tm1 / EX_T_AVG,
  s_iEIPIII_for_sv_tm1 = iEIPIII_for_sv_tm1 / EX_T_AVG )

# No extreme outliers

# Create copys 
df_f_sc_fd_copy <- df_f_sc_fd
df_f_sc_sn_copy <- df_f_sc_sn
df_f_sc_n_copy <- df_f_sc_n
df_f_sc_t_copy <- df_f_sc_t

imputation <- function(df){
  df_uno <- df %>% filter(tr_ob==0)
  
  # Step 1: Computing coefficients using only never-treated and not-yet treated units
  base <- feols(Y ~ 0 + r + s_EIPI_t + s_EIPIII_t + s_EIPI_tm1 + s_EIPIII_tm1 + s_AGE_AVG_t + s_d_NUM_ADTS_t + s_d_NUM_KIDS_t + factor(YYMM), 
                weights=~FINLWT21_AVG,cluster=~ID, data=df_uno)
  
  # Step 2: Imputing the counter-factual outcomes for all units
  df = df %>% mutate(
    coeff_r = base$coefficients[1],
    coeff_EIPI_t = base$coefficients[2],
    coeff_EIPIII_t = base$coefficients[3],
    coeff_EIPI_tm1 = base$coefficients[4],
    coeff_EIPIII_tm1 = base$coefficients[5],
    coeff_AGE = base$coefficients[6],
    coeff_ADTS = base$coefficients[7],
    coeff_KIDS = base$coefficients[8],
    YYMM_fe = ifelse(YYMM==2008,NA,
                     ifelse(YYMM==2009,base$coefficients[9],
                            ifelse(YYMM==2010,base$coefficients[10],
                                   ifelse(YYMM==2011,base$coefficients[11],
                                          ifelse(YYMM==2012,base$coefficients[12],
                                                 ifelse(YYMM==2101,base$coefficients[13],
                                                        ifelse(YYMM==2102,base$coefficients[14],
                                                               ifelse(YYMM==2103,base$coefficients[15],
                                                                      ifelse(YYMM==2104,base$coefficients[16],
                                                                             ifelse(YYMM==2105,base$coefficients[17],
                                                                                    ifelse(YYMM==2106,base$coefficients[18],
                                                                                           ifelse(YYMM==2107,base$coefficients[19],
                                                                                                  ifelse(YYMM==2108,base$coefficients[20],base$coefficients[21]))))))))))))),
    
    Y_0 = coeff_r * r + coeff_EIPI_t * s_EIPI_t + coeff_EIPIII_t * s_EIPIII_t + 
      coeff_EIPI_tm1 * s_EIPI_tm1 + coeff_EIPIII_tm1 * s_EIPIII_tm1 + 
      coeff_AGE * s_AGE_AVG_t + coeff_ADTS * s_d_NUM_ADTS_t + coeff_KIDS * s_d_NUM_KIDS_t + YYMM_fe,
    
    # Step 3: Differencing the counter-factual from the observed outcome
    
    Y_new = Y - Y_0)
  
  return(df)
}

df_f_sc_fd <- imputation(df_f_sc_fd_copy) # Y is s_d_EX_FD
df_f_sc_fd <- df_f_sc_fd %>% filter(tr_ob==1) 

df_f_sc_sn <- imputation(df_f_sc_sn_copy) # Y is s_d_EX_SN
df_f_sc_sn <- df_f_sc_sn %>% filter(tr_ob==1) 

df_f_sc_n <- imputation(df_f_sc_n_copy) # Y is s_d_EX_N
df_f_sc_n <- df_f_sc_n %>% filter(tr_ob==1) 

df_f_sc_t <- imputation(df_f_sc_t_copy) # Y is s_d_EX_T
df_f_sc_t <- df_f_sc_t %>% filter(tr_ob==1) 

### Table III ####
##### Panel A: Normalized level change - Normalized EIPII amount ####

# Food
n_w_fd_cle_le_to <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                          weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd)
# summary(n_w_fd_cle_le_to)

# Strictly non-durables
n_w_sn_cle_le_to <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                          weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn)
# summary(n_w_sn_cle_le_to)

# Non-durables
n_w_n_cle_le_to <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                         weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n)
# summary(n_w_n_cle_le_to)

# Total
n_w_t_cle_le_to <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                         weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t)
# summary(n_w_t_cle_le_to)

etable(n_w_fd_cle_le_to,n_w_sn_cle_le_to,n_w_n_cle_le_to,n_w_t_cle_le_to, style.tex = style.tex("aer"))

##### Panel B: Normalized level change - Normalized EIPII indicator ####
imputation_i <- function(df){
  df_uno <- df %>% filter(tr_ob==0)
  
  # Step 1: Computing coefficients using only never-treated and not-yet treated units
  base <- feols(Y ~ 0 + r + s_iEIPI_t + s_iEIPIII_t + s_iEIPI_tm1 + s_iEIPIII_tm1 + s_AGE_AVG_t + s_d_NUM_ADTS_t + s_d_NUM_KIDS_t + factor(YYMM), 
                weights=~FINLWT21_AVG,cluster=~ID, data=df_uno)
  
  # Step 2: Imputing the counter-factual outcomes for all units
  
  df = df %>% mutate(
    coeff_r = base$coefficients[1],
    coeff_EIPI_t = base$coefficients[2],
    coeff_EIPIII_t = base$coefficients[3],
    coeff_EIPI_tm1 = base$coefficients[4],
    coeff_EIPIII_tm1 = base$coefficients[5],
    coeff_AGE = base$coefficients[6],
    coeff_ADTS = base$coefficients[7],
    coeff_KIDS = base$coefficients[8],
    YYMM_fe = ifelse(YYMM==2008,NA,
                     ifelse(YYMM==2009,base$coefficients[9],
                            ifelse(YYMM==2010,base$coefficients[10],
                                   ifelse(YYMM==2011,base$coefficients[11],
                                          ifelse(YYMM==2012,base$coefficients[12],
                                                 ifelse(YYMM==2101,base$coefficients[13],
                                                        ifelse(YYMM==2102,base$coefficients[14],
                                                               ifelse(YYMM==2103,base$coefficients[15],
                                                                      ifelse(YYMM==2104,base$coefficients[16],
                                                                             ifelse(YYMM==2105,base$coefficients[17],
                                                                                    ifelse(YYMM==2106,base$coefficients[18],
                                                                                           ifelse(YYMM==2107,base$coefficients[19],
                                                                                                  ifelse(YYMM==2108,base$coefficients[20],base$coefficients[21]))))))))))))),
    
    Y_0 = coeff_r * r + coeff_EIPI_t * s_iEIPI_t + coeff_EIPIII_t * s_iEIPIII_t + 
      coeff_EIPI_tm1 * s_iEIPI_tm1 + coeff_EIPIII_tm1 * s_iEIPIII_tm1 +
      coeff_AGE * s_AGE_AVG_t + coeff_ADTS * s_d_NUM_ADTS_t + coeff_KIDS * s_d_NUM_KIDS_t + YYMM_fe,
    
    # Step 3: Differencing the counter-factual from the observed outcome
    
    Y_new = Y - Y_0)
  
  return(df)
}

df_f_sc_fd <- imputation_i(df_f_sc_fd_copy) # Y is s_d_EX_FD
df_f_sc_fd <- df_f_sc_fd %>% filter(tr_ob==1) 

df_f_sc_sn <- imputation_i(df_f_sc_sn_copy) # Y is s_d_EX_SN
df_f_sc_sn <- df_f_sc_sn %>% filter(tr_ob==1) 

df_f_sc_n <- imputation_i(df_f_sc_n_copy) # Y is s_d_EX_N
df_f_sc_n <- df_f_sc_n %>% filter(tr_ob==1) 

df_f_sc_t <- imputation_i(df_f_sc_t_copy) # Y is s_d_EX_T
df_f_sc_t <- df_f_sc_t %>% filter(tr_ob==1) 

# Food
n_w_fd_cle_i_to <- feols(Y_new ~ s_iEIPII_t + s_iEIPII_tm1, 
                         weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd)
# summary(n_w_fd_cle_i_to)

# Strictly non-durables
n_w_sn_cle_i_to <- feols(Y_new ~ s_iEIPII_t + s_iEIPII_tm1, 
                         weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn)
# summary(n_w_sn_cle_i_to)

# Non-durables
n_w_n_cle_i_to <- feols(Y_new ~ s_iEIPII_t + s_iEIPII_tm1, 
                        weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n)
# summary(n_w_n_cle_i_to)

# Total
n_w_t_cle_i_to <- feols(Y_new ~ s_iEIPII_t + s_iEIPII_tm1, 
                        weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t)
# summary(n_w_t_cle_i_to)

etable(n_w_fd_cle_i_to,n_w_sn_cle_i_to,n_w_n_cle_i_to,n_w_t_cle_i_to, style.tex = style.tex("aer"))

### Table IV ####

imputation_one_lag <- function(df){
  df_uno <- df %>% filter(tr_ob==0)
  
  # Step 1: Computing coefficients using only never-treated and not-yet treated units
  base <- feols(Y ~ 0 + r + s_EIPI_t + s_EIPIII_t + s_EIPI_tm1 + s_EIPIII_tm1 + 
                  s_AGE_AVG_t + s_d_NUM_ADTS_t + s_d_NUM_KIDS_t + factor(YYMM), 
                weights=~FINLWT21_AVG,cluster=~ID, data=df_uno)
  
  summary(base)
  
  # Step 2: Imputing the counter-factual outcomes 
  
  df = df %>% mutate(
    coeff_r = base$coefficients[1],
    coeff_EIPI_t = base$coefficients[2],
    coeff_EIPIII_t = base$coefficients[3],
    coeff_EIPI_tm1 = base$coefficients[4], 
    coeff_EIPIII_tm1 = base$coefficients[5], 
    coeff_AGE = base$coefficients[6],
    coeff_ADTS = base$coefficients[7],
    coeff_KIDS = base$coefficients[8],
    YYMM_fe = ifelse(YYMM==2008, NA,
              ifelse(YYMM==2009,base$coefficients[9],
              ifelse(YYMM==2010,base$coefficients[10],
              ifelse(YYMM==2011,base$coefficients[11],
              ifelse(YYMM==2012,base$coefficients[12],
              ifelse(YYMM==2101,base$coefficients[13],
              ifelse(YYMM==2102,base$coefficients[14],
              ifelse(YYMM==2103,base$coefficients[15],
              ifelse(YYMM==2104,base$coefficients[16],
              ifelse(YYMM==2105,base$coefficients[17],
              ifelse(YYMM==2106,base$coefficients[18],
              ifelse(YYMM==2107,base$coefficients[19],
              ifelse(YYMM==2108,base$coefficients[20],base$coefficients[21]))))))))))))),
    
    Y_0 = coeff_r * r + coeff_EIPI_t * s_EIPI_t + coeff_EIPIII_t * s_EIPIII_t + 
      coeff_EIPI_tm1 * s_EIPI_tm1 + coeff_EIPIII_tm1 * s_EIPIII_tm1 + 
      coeff_AGE * s_AGE_AVG_t + coeff_ADTS * s_d_NUM_ADTS_t + coeff_KIDS * s_d_NUM_KIDS_t + YYMM_fe,
    
    # Step 3: Differencing the counter-factual from the observed outcome
    
    Y_new = Y - Y_0)
  
  return(df)
}

df_f_sc_fd <- imputation_one_lag(df_f_sc_fd_copy) # Y is s_d_EX_FD
df_f_sc_fd <- df_f_sc_fd %>% filter(tr_ob==1) 

df_f_sc_sn <- imputation_one_lag(df_f_sc_sn_copy) # Y is s_d_EX_SN
df_f_sc_sn <- df_f_sc_sn %>% filter(tr_ob==1) 

df_f_sc_n <- imputation_one_lag(df_f_sc_n_copy) # Y is s_d_EX_N
df_f_sc_n <- df_f_sc_n %>% filter(tr_ob==1) 

df_f_sc_t <- imputation_one_lag(df_f_sc_t_copy) # Y is s_d_EX_T
df_f_sc_t <- df_f_sc_t %>% filter(tr_ob==1) 

##### WLS ####
# Food
n_w_fd_cle_le <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                       weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd)
# summary(n_w_fd_cle_le)

# Strictly non-durables 
n_w_sn_cle_le <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                       weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn)
# summary(n_w_sn_cle_le)

# Non-durables 
n_w_n_cle_le <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1,
                      weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n)
# summary(n_w_n_cle_le)

# Total
n_w_t_cle_le <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                      weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t)
# summary(n_w_t_cle_le)

etable(n_w_fd_cle_le,n_w_sn_cle_le,n_w_n_cle_le,n_w_t_cle_le, style.tex = style.tex("aer"))

# Cumulative amount
deltaMethod(n_w_fd_cle_le, "s_EIPII_t+s_EIPII_t+s_EIPII_tm1",vcov.=vcov(n_w_fd_cle_le))
deltaMethod(n_w_sn_cle_le, "s_EIPII_t+s_EIPII_t+s_EIPII_tm1",vcov.=vcov(n_w_sn_cle_le))
deltaMethod(n_w_n_cle_le, "s_EIPII_t+s_EIPII_t+s_EIPII_tm1",vcov.=vcov(n_w_n_cle_le))
deltaMethod(n_w_t_cle_le, "s_EIPII_t+s_EIPII_t+s_EIPII_tm1",vcov.=vcov(n_w_t_cle_le))



### Table V #####

# dummies
df_all_cu_cu <- df_all_cu_cu %>% mutate(
  iEIPI_t = ifelse(EIPI_t>0,1,0),
  
  iEIPII_t = ifelse(EIPII_t>0,1,0),
  
  iEIPIII_t = ifelse(EIPIII_t>0,1,0))

# Computing difference in log
df_all_cu_cu$ln_EX_FD_t <- log(df_all_cu_cu$EX_FD_t)
df_all_cu_cu$ln_EX_SN_t <- log(df_all_cu_cu$EX_SN_t)
df_all_cu_cu$ln_EX_N_t <- log(df_all_cu_cu$EX_N_t)
df_all_cu_cu$ln_EX_T_t <- log(df_all_cu_cu$EX_T_t)

df_all_cu_cu$ln_EX_FD_tm1 <- log(df_all_cu_cu$EX_FD_tm1)
df_all_cu_cu$ln_EX_SN_tm1 <- log(df_all_cu_cu$EX_SN_tm1)
df_all_cu_cu$ln_EX_N_tm1 <- log(df_all_cu_cu$EX_N_tm1)
df_all_cu_cu$ln_EX_T_tm1 <- log(df_all_cu_cu$EX_T_tm1)

df_all_cu_cu$d_ln_EX_FD_t <- df_all_cu_cu$ln_EX_FD_t - df_all_cu_cu$ln_EX_FD_tm1
df_all_cu_cu$d_ln_EX_SN_t <- df_all_cu_cu$ln_EX_SN_t - df_all_cu_cu$ln_EX_SN_tm1
df_all_cu_cu$d_ln_EX_N_t <- df_all_cu_cu$ln_EX_N_t - df_all_cu_cu$ln_EX_N_tm1
df_all_cu_cu$d_ln_EX_T_t <- df_all_cu_cu$ln_EX_T_t - df_all_cu_cu$ln_EX_T_tm1

##### Panel A: Change in Level-Level ####
# Food - Just EIPIt
c_fd_nw =feols(d_EX_FD_t ~ EIPI_t + EIPII_t + EIPIII_t +
                 AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t + factor(YYMM), 
               cluster=~ID, data=df_all_cu_cu)
# summary(c_fd_nw)

# Strict non-durables - Just EIPIt
c_sn_nw =feols(d_EX_SN_t ~ EIPI_t + EIPII_t + EIPIII_t +
                 AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t + factor(YYMM),
               cluster=~ID, data=df_all_cu_cu)
# summary(c_sn_nw)

# Non-durables - Just EIPIt
c_n_nw =feols(d_EX_N_t ~ EIPI_t + EIPII_t + EIPIII_t +
                AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t + factor(YYMM),
              cluster=~ID, data=df_all_cu_cu)
# summary(c_n_nw)

# Total - Just EIPIt
c_t_nw =feols(d_EX_T_t ~ EIPI_t + EIPII_t + EIPIII_t +
                AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t + factor(YYMM),
              cluster=~ID, data=df_all_cu_cu)
# summary(c_t_nw)

etable(c_fd_nw,c_sn_nw,c_n_nw,c_t_nw, style.tex = style.tex("aer"))

##### Panel B: Change in Level - Indicator ####

# Food - only EIPIt
c_fd_le_i_nw =feols(d_EX_FD_t ~ iEIPI_t + iEIPII_t + iEIPIII_t +
                      AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t + factor(YYMM),
                    cluster=~ID, data=df_all_cu_cu)
# summary(c_fd_le_i_nw)

# Strict non-durables - only EIPIt
c_sn_le_i_nw =feols(d_EX_SN_t ~ iEIPI_t + iEIPII_t + iEIPIII_t +
                      AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t + factor(YYMM),
                    cluster=~ID, data=df_all_cu_cu)
# summary(c_sn_le_i_nw)

# Non-durables - only EIPIt
c_n_le_i_nw =feols(d_EX_N_t ~ iEIPI_t + iEIPII_t + iEIPIII_t +
                     AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t + factor(YYMM),
                   cluster=~ID, data=df_all_cu_cu)
# summary(c_n_le_i_nw)

# Total - only EIPIt
c_t_le_i_nw =feols(d_EX_T_t ~ iEIPI_t + iEIPII_t + iEIPIII_t +
                     AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t + factor(YYMM),
                   cluster=~ID, data=df_all_cu_cu)
# summary(c_t_le_i_nw)

etable(c_fd_le_i_nw,c_sn_le_i_nw,c_n_le_i_nw,c_t_le_i_nw, style.tex = style.tex("aer"))


### Table VI ####
df_f_split <- df_f %>% filter(!(is.na(d_EX_N_t)) & !is.na(EIPII_t) & EIPII_t > 0)

wtd.quantile(df_f_split$LIQUDYRX, q=1/3, na.rm = TRUE, weight=df_f_split$FINLWT21_AVG)
wtd.quantile(df_f_split$LIQUDYRX, q=2/3, na.rm = TRUE, weight=df_f_split$FINLWT21_AVG)

liq_groups <- function(df){
  df <- df %>% mutate(
    low_liq = ifelse(LIQUDYRX<=2000,1,0),
    high_liq = ifelse(LIQUDYRX>=12000,1,0),
    mid_liq = ifelse((LIQUDYRX<12000 & LIQUDYRX>2000),1,0),
    
    s_EIPI_t_low = s_EIPI_t*low_liq,
    s_EIPI_t_mid = s_EIPI_t*mid_liq,
    s_EIPI_t_high = s_EIPI_t*high_liq,
    s_EIPI_tm1_low = s_EIPI_tm1*low_liq,
    s_EIPI_tm1_mid = s_EIPI_tm1*mid_liq,
    s_EIPI_tm1_high = s_EIPI_tm1*high_liq,
    
    s_EIPII_t_low = s_EIPII_t*low_liq,
    s_EIPII_t_mid = s_EIPII_t*mid_liq,
    s_EIPII_t_high = s_EIPII_t*high_liq,
    s_EIPII_tm1_low = s_EIPII_tm1*low_liq,
    s_EIPII_tm1_mid = s_EIPII_tm1*mid_liq,
    s_EIPII_tm1_high = s_EIPII_tm1*high_liq,
    
    s_EIPIII_t_low = s_EIPIII_t*low_liq,
    s_EIPIII_t_mid = s_EIPIII_t*mid_liq,
    s_EIPIII_t_high = s_EIPIII_t*high_liq,
    s_EIPIII_tm1_low = s_EIPIII_tm1*low_liq,
    s_EIPIII_tm1_mid = s_EIPIII_tm1*mid_liq,
    s_EIPIII_tm1_high = s_EIPIII_tm1*high_liq)
  return(df)
}

imputation_liq<- function(df){
  df_uno <- df %>% filter(tr_ob==0)
  
  # Step 1: Computing coefficients using only never-treated and not-yet treated units
  base <- feols(Y ~ 0 + low_liq + high_liq + 
                  s_EIPI_t + s_EIPI_t_low + s_EIPI_t_high + 
                  s_EIPI_tm1 + s_EIPI_tm1_low + s_EIPI_tm1_high +
                  s_EIPIII_t + s_EIPIII_t_low + s_EIPIII_t_high + 
                  s_EIPIII_tm1 + s_EIPIII_tm1_low + s_EIPIII_tm1_high +                             
                  s_AGE_AVG_t + s_d_NUM_ADTS_t + s_d_NUM_KIDS_t + factor(YYMM), 
                weights=~FINLWT21_AVG,cluster=~ID, data=df_uno)
  
  summary(base)
  # Step 2: Imputing the counter-factual outcomes 
  
  df = df %>% mutate(
    coeff_low_liq = base$coefficients[1],
    coeff_high_liq = base$coefficients[2],
    coeff_EIPI_t = base$coefficients[3],
    coeff_EIPI_t_low = base$coefficients[4],
    coeff_EIPI_t_high = base$coefficients[5],
    coeff_EIPI_tm1 = base$coefficients[6],
    coeff_EIPI_tm1_low = base$coefficients[7],
    coeff_EIPI_tm1_high = base$coefficients[8],    
    coeff_EIPIII_t = base$coefficients[9],
    coeff_EIPIII_t_low = base$coefficients[10], 
    coeff_EIPIII_t_high = base$coefficients[11], 
    coeff_EIPIII_tm1 = base$coefficients[12],
    coeff_EIPIII_tm1_low = base$coefficients[13], 
    coeff_EIPIII_tm1_high = base$coefficients[14],    
    coeff_AGE = base$coefficients[15],
    coeff_ADTS = base$coefficients[16],
    coeff_KIDS = base$coefficients[17],
    YYMM_fe = ifelse(YYMM==2008, NA,
              ifelse(YYMM==2009,base$coefficients[18],
              ifelse(YYMM==2010,base$coefficients[19],
              ifelse(YYMM==2011,base$coefficients[20],
              ifelse(YYMM==2012,base$coefficients[21],
              ifelse(YYMM==2101,base$coefficients[22],
              ifelse(YYMM==2102,base$coefficients[23],
              ifelse(YYMM==2103,base$coefficients[24],
              ifelse(YYMM==2104,base$coefficients[25],
              ifelse(YYMM==2105,base$coefficients[26],
              ifelse(YYMM==2106,base$coefficients[27],
              ifelse(YYMM==2107,base$coefficients[28],
              ifelse(YYMM==2108,base$coefficients[29],base$coefficients[30]))))))))))))),
    
    Y_0 = coeff_low_liq * low_liq + coeff_high_liq * high_liq +
      coeff_EIPI_t * s_EIPI_t + coeff_EIPI_t_low * s_EIPI_t_low + coeff_EIPI_t_high * s_EIPI_t_high + 
      coeff_EIPI_tm1 * s_EIPI_tm1 + coeff_EIPI_tm1_low * s_EIPI_tm1_low + coeff_EIPI_tm1_high * s_EIPI_tm1_high +
      coeff_EIPIII_t * s_EIPIII_t + coeff_EIPIII_t_low * s_EIPIII_t_low + coeff_EIPIII_t_high * s_EIPIII_t_high + 
      coeff_EIPIII_tm1 * s_EIPIII_tm1 + coeff_EIPIII_tm1_low * s_EIPIII_tm1_low + coeff_EIPIII_tm1_high * s_EIPIII_tm1_high +  
      coeff_AGE * s_AGE_AVG_t + coeff_ADTS * s_d_NUM_ADTS_t + coeff_KIDS * s_d_NUM_KIDS_t + YYMM_fe,
    
    # Step 3: Differencing the counter-factual from the observed outcome
    
    Y_new = Y - Y_0)
  
  return(df)
}

df_f_sc_fd <- liq_groups(df_f_sc_fd_copy)
df_f_sc_fd <- imputation_liq(df_f_sc_fd)
df_f_sc_fd <- df_f_sc_fd %>% filter(tr_ob==1)

df_f_sc_sn <- liq_groups(df_f_sc_sn_copy)
df_f_sc_sn <- imputation_liq(df_f_sc_sn)
df_f_sc_sn <- df_f_sc_sn %>% filter(tr_ob==1)

df_f_sc_n <- liq_groups(df_f_sc_n_copy)
df_f_sc_n <- imputation_liq(df_f_sc_n)
df_f_sc_n <- df_f_sc_n %>% filter(tr_ob==1)

df_f_sc_t <- liq_groups(df_f_sc_t_copy)
df_f_sc_t <- imputation_liq(df_f_sc_t)
df_f_sc_t <- df_f_sc_t %>% filter(tr_ob==1)

# Food 
n_w_fd_cle_le_liq <- feols(Y_new ~ low_liq + high_liq +
                             s_EIPII_t + s_EIPII_t_low + s_EIPII_t_high + 
                             s_EIPII_tm1 + s_EIPII_tm1_low + s_EIPII_tm1_high, 
                           weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd)
# summary(n_w_fd_cle_le_liq)

# Strictly non-durables
n_w_sn_cle_le_liq <- feols(Y_new ~ low_liq + high_liq +
                             s_EIPII_t + s_EIPII_t_low + s_EIPII_t_high + 
                             s_EIPII_tm1 + s_EIPII_tm1_low + s_EIPII_tm1_high, 
                           weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn)
# summary(n_w_sn_cle_le_liq)

# Non-durables 
n_w_n_cle_le_liq <- feols(Y_new ~ low_liq + high_liq +
                            s_EIPII_t + s_EIPII_t_low + s_EIPII_t_high + 
                            s_EIPII_tm1 + s_EIPII_tm1_low + s_EIPII_tm1_high, 
                          weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n)
# summary(n_w_n_cle_le_liq)

# Total
n_w_t_cle_le_liq <-feols(Y_new ~ low_liq + high_liq +
                           s_EIPII_t + s_EIPII_t_low + s_EIPII_t_high + 
                           s_EIPII_tm1 + s_EIPII_tm1_low + s_EIPII_tm1_high, 
                         weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t)
# summary(n_w_t_cle_le_liq)

etable(n_w_fd_cle_le_liq,n_w_sn_cle_le_liq,n_w_n_cle_le_liq,n_w_t_cle_le_liq, style.tex = style.tex("aer"))

# Joint test
linearHypothesis(n_w_fd_cle_le_liq, c("s_EIPII_t_low=0","s_EIPII_t_high=0"),white.adjust = "hc1",vcov.=vcov(n_w_fd_cle_le_liq))
linearHypothesis(n_w_n_cle_le_liq, c("s_EIPII_t_low=0","s_EIPII_t_high=0"),white.adjust = "hc1",vcov.=vcov(n_w_n_cle_le_liq))
linearHypothesis(n_w_t_cle_le_liq, c("s_EIPII_t_low=0","s_EIPII_t_high=0"),white.adjust = "hc1",vcov.=vcov(n_w_t_cle_le_liq))

# For implied spending by group
deltaMethod(n_w_fd_cle_le_liq, "s_EIPII_t+(s_EIPII_t_low)",vcov.=vcov(n_w_fd_cle_le_liq))
deltaMethod(n_w_fd_cle_le_liq, "s_EIPII_t+(s_EIPII_t_high)",vcov.=vcov(n_w_fd_cle_le_liq))

deltaMethod(n_w_n_cle_le_liq, "s_EIPII_t+(s_EIPII_t_low)",vcov.=vcov(n_w_n_cle_le_liq))
deltaMethod(n_w_n_cle_le_liq, "s_EIPII_t+(s_EIPII_t_high)",vcov.=vcov(n_w_n_cle_le_liq))

deltaMethod(n_w_t_cle_le_liq, "s_EIPII_t+(s_EIPII_t_low)",vcov.=vcov(n_w_t_cle_le_liq))
deltaMethod(n_w_t_cle_le_liq, "s_EIPII_t+(s_EIPII_t_high)",vcov.=vcov(n_w_t_cle_le_liq))

### Table VIII ####
wfh_ind <- read_csv("wfh_ind.csv")

df_f_split_wfh <- df_f_split %>% inner_join(wfh_ind, by="ID")

wfh_q1 <- wtd.quantile(df_f_split_wfh$wfh, q=1/3, na.rm = TRUE, weight=df_f_split_wfh$FINLWT21_AVG)
wfh_q2 <- wtd.quantile(df_f_split_wfh$wfh, q=2/3, na.rm = TRUE, weight=df_f_split_wfh$FINLWT21_AVG)


wfh_groups <- function(df){
  df <- df %>% mutate(
    low_wfh = ifelse(wfh<=wfh_q1,1,0),
    high_wfh = ifelse(wfh>=wfh_q2,1,0),
    mid_wfh = ifelse((wfh<wfh_q2 & wfh>wfh_q1),1,0),
    
    s_EIPI_t_low = s_EIPI_t*low_wfh,
    s_EIPI_t_mid = s_EIPI_t*mid_wfh,
    s_EIPI_t_high = s_EIPI_t*high_wfh,
    s_EIPI_tm1_low = s_EIPI_tm1*low_wfh,
    s_EIPI_tm1_mid = s_EIPI_tm1*mid_wfh,
    s_EIPI_tm1_high = s_EIPI_tm1*high_wfh,
    
    s_EIPII_t_low = s_EIPII_t*low_wfh,
    s_EIPII_t_mid = s_EIPII_t*mid_wfh,
    s_EIPII_t_high = s_EIPII_t*high_wfh,
    s_EIPII_tm1_low = s_EIPII_tm1*low_wfh,
    s_EIPII_tm1_mid = s_EIPII_tm1*mid_wfh,
    s_EIPII_tm1_high = s_EIPII_tm1*high_wfh,
    
    s_EIPIII_t_low = s_EIPIII_t*low_wfh,
    s_EIPIII_t_mid = s_EIPIII_t*mid_wfh,
    s_EIPIII_t_high = s_EIPIII_t*high_wfh,
    s_EIPIII_tm1_low = s_EIPIII_tm1*low_wfh,
    s_EIPIII_tm1_mid = s_EIPIII_tm1*mid_wfh,
    s_EIPIII_tm1_high = s_EIPIII_tm1*high_wfh)
  return(df)
}

imputation_wfh<- function(df){
  df_uno <- df %>% filter(tr_ob==0)
  
  # Step 1: Computing coefficients using only never-treated and not-yet treated units
  base <- feols(Y ~ 0 + low_wfh + mid_wfh + 
                  s_EIPI_t + s_EIPI_t_low + s_EIPI_t_mid + 
                  s_EIPI_tm1 + s_EIPI_tm1_low + s_EIPI_tm1_mid +
                  s_EIPIII_t + s_EIPIII_t_low + s_EIPIII_t_mid + 
                  s_EIPIII_tm1 + s_EIPIII_tm1_low + s_EIPIII_tm1_mid +                             
                  s_AGE_AVG_t + s_d_NUM_ADTS_t + s_d_NUM_KIDS_t + factor(YYMM), 
                weights=~FINLWT21_AVG,cluster=~ID, data=df_uno)
  
  # Step 2: Imputing the counter-factual outcomes for all units
  
  df = df %>% mutate(
    coeff_low_wfh = base$coefficients[1],
    coeff_mid_wfh = base$coefficients[2],
    coeff_EIPI_t = base$coefficients[3],
    coeff_EIPI_t_low = base$coefficients[4],
    coeff_EIPI_t_mid = base$coefficients[5],
    coeff_EIPI_tm1 = base$coefficients[6],
    coeff_EIPI_tm1_low = base$coefficients[7],
    coeff_EIPI_tm1_mid = base$coefficients[8],    
    coeff_EIPIII_t = base$coefficients[9],
    coeff_EIPIII_t_low = base$coefficients[10], 
    coeff_EIPIII_t_mid = base$coefficients[11], 
    coeff_EIPIII_tm1 = base$coefficients[12],
    coeff_EIPIII_tm1_low = base$coefficients[13], 
    coeff_EIPIII_tm1_mid = base$coefficients[14],    
    coeff_AGE = base$coefficients[15],
    coeff_ADTS = base$coefficients[16],
    coeff_KIDS = base$coefficients[17],
    YYMM_fe = ifelse(YYMM==2008, NA,
                     ifelse(YYMM==2009,base$coefficients[18],
                            ifelse(YYMM==2010,base$coefficients[19],
                                   ifelse(YYMM==2011,base$coefficients[20],
                                          ifelse(YYMM==2012,base$coefficients[21],
                                                 ifelse(YYMM==2101,base$coefficients[22],
                                                        ifelse(YYMM==2102,base$coefficients[23],
                                                               ifelse(YYMM==2103,base$coefficients[24],
                                                                      ifelse(YYMM==2104,base$coefficients[25],
                                                                             ifelse(YYMM==2105,base$coefficients[26],
                                                                                    ifelse(YYMM==2106,base$coefficients[27],
                                                                                           ifelse(YYMM==2107,base$coefficients[28],
                                                                                                  ifelse(YYMM==2108,base$coefficients[29],base$coefficients[30]))))))))))))),
    
    Y_0 = coeff_low_wfh * low_wfh + coeff_mid_wfh * mid_wfh +
      coeff_EIPI_t * s_EIPI_t + coeff_EIPI_t_low * s_EIPI_t_low + coeff_EIPI_t_mid * s_EIPI_t_mid + 
      coeff_EIPI_tm1 * s_EIPI_tm1 + coeff_EIPI_tm1_low * s_EIPI_tm1_low + coeff_EIPI_tm1_mid * s_EIPI_tm1_mid +
      coeff_EIPIII_t * s_EIPIII_t + coeff_EIPIII_t_low * s_EIPIII_t_low + coeff_EIPIII_t_mid * s_EIPIII_t_mid + 
      coeff_EIPIII_tm1 * s_EIPIII_tm1 + coeff_EIPIII_tm1_low * s_EIPIII_tm1_low + coeff_EIPIII_tm1_mid * s_EIPIII_tm1_mid +  
      coeff_AGE * s_AGE_AVG_t + coeff_ADTS * s_d_NUM_ADTS_t + coeff_KIDS * s_d_NUM_KIDS_t + YYMM_fe,
    
    # Step 3: Differencing the counter-factual from the observed outcome
    
    Y_new = Y - Y_0)
  
  return(df)
}

df_f_sc_fd <- wfh_groups(df_f_sc_fd_copy %>% select(-matches("wfh")) %>% left_join(wfh_ind, by="ID"))
df_f_sc_fd <- imputation_wfh(df_f_sc_fd)
df_f_sc_fd <- df_f_sc_fd %>% filter(tr_ob==1)

df_f_sc_sn <- wfh_groups(df_f_sc_sn_copy %>% select(-matches("wfh")) %>% left_join(wfh_ind, by="ID"))
df_f_sc_sn <- imputation_wfh(df_f_sc_sn)
df_f_sc_sn <- df_f_sc_sn %>% filter(tr_ob==1)

df_f_sc_n <- wfh_groups(df_f_sc_n_copy %>% select(-matches("wfh")) %>% left_join(wfh_ind, by="ID"))
df_f_sc_n <- imputation_wfh(df_f_sc_n)
df_f_sc_n <- df_f_sc_n %>% filter(tr_ob==1)

df_f_sc_t <- wfh_groups(df_f_sc_t_copy %>% select(-matches("wfh")) %>% left_join(wfh_ind, by="ID"))
df_f_sc_t <- imputation_wfh(df_f_sc_t)
df_f_sc_t <- df_f_sc_t %>% filter(tr_ob==1)

n_w_fd_cle_le_wfh <- feols(Y_new ~ low_wfh + mid_wfh +
                             s_EIPII_t + s_EIPII_t_low + s_EIPII_t_mid + 
                             s_EIPII_tm1 + s_EIPII_tm1_low + s_EIPII_tm1_mid, 
                           weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd)
# summary(n_w_fd_cle_le_wfh)

n_w_sn_cle_le_wfh <- feols(Y_new ~ low_wfh + mid_wfh +
                             s_EIPII_t + s_EIPII_t_low + s_EIPII_t_mid + 
                             s_EIPII_tm1 + s_EIPII_tm1_low + s_EIPII_tm1_mid, 
                           weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn)
# summary(n_w_sn_cle_le_wfh)

n_w_n_cle_le_wfh <- feols(Y_new ~ low_wfh + mid_wfh +
                            s_EIPII_t + s_EIPII_t_low + s_EIPII_t_mid + 
                            s_EIPII_tm1 + s_EIPII_tm1_low + s_EIPII_tm1_mid, 
                          weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n)
# summary(n_w_n_cle_le_wfh)

n_w_t_cle_le_wfh <-feols(Y_new ~ low_wfh + mid_wfh +
                           s_EIPII_t + s_EIPII_t_low + s_EIPII_t_mid + 
                           s_EIPII_tm1 + s_EIPII_tm1_low + s_EIPII_tm1_mid, 
                         weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t)
# summary(n_w_t_cle_le_wfh)

etable(n_w_fd_cle_le_wfh,n_w_sn_cle_le_wfh,n_w_n_cle_le_wfh,n_w_t_cle_le_wfh, style.tex = style.tex("aer"))

linearHypothesis(n_w_fd_cle_le_wfh, c("s_EIPII_t_low=0","s_EIPII_t_mid=0"),white.adjust = "hc1",vcov.=vcov(n_w_fd_cle_le_wfh))
linearHypothesis(n_w_n_cle_le_wfh, c("s_EIPII_t_low=0","s_EIPII_t_mid=0"),white.adjust = "hc1",vcov.=vcov(n_w_n_cle_le_wfh))
linearHypothesis(n_w_t_cle_le_wfh, c("s_EIPII_t_low=0","s_EIPII_t_mid=0"),white.adjust = "hc1",vcov.=vcov(n_w_t_cle_le_wfh))

### For implied spending by group
deltaMethod(n_w_fd_cle_le_wfh, "s_EIPII_t+(s_EIPII_t_low)",vcov.=vcov(n_w_fd_cle_le_wfh))
deltaMethod(n_w_fd_cle_le_wfh, "s_EIPII_t+(s_EIPII_t_mid)",vcov.=vcov(n_w_fd_cle_le_wfh))

deltaMethod(n_w_n_cle_le_wfh, "s_EIPII_t+(s_EIPII_t_low)",vcov.=vcov(n_w_n_cle_le_wfh))
deltaMethod(n_w_n_cle_le_wfh, "s_EIPII_t+(s_EIPII_t_mid)",vcov.=vcov(n_w_n_cle_le_wfh))

deltaMethod(n_w_t_cle_le_wfh, "s_EIPII_t+(s_EIPII_t_low)",vcov.=vcov(n_w_t_cle_le_wfh))
deltaMethod(n_w_t_cle_le_wfh, "s_EIPII_t+(s_EIPII_t_mid)",vcov.=vcov(n_w_t_cle_le_wfh))

### Table C.4 ####
##### Panel A: Change in Log - Indicator ####

# Food
fd_ln_i_nw =feols(d_ln_EX_FD_t ~ iEIPI_t + iEIPII_t + iEIPIII_t + AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t + factor(YYMM), 
                  cluster=~ID, data=df_all_cu)
# summary(fd_ln_i_nw)

# Strict non-durables
sn_ln_i_nw =feols(d_ln_EX_SN_t ~ iEIPI_t + iEIPII_t + iEIPIII_t + AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t + factor(YYMM), 
                  cluster=~ID, data=df_all_cu)
# summary(sn_ln_i_nw)

# Non-durables
n_ln_i_nw =feols(d_ln_EX_N_t ~ iEIPI_t + iEIPII_t + iEIPIII_t + AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t + factor(YYMM), 
                 cluster=~ID, data=df_all_cu)
# summary(n_ln_i_nw)

# Total
t_ln_i_nw =feols(d_ln_EX_T_t ~ iEIPI_t + iEIPII_t + iEIPIII_t + AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t + factor(YYMM),
                 cluster=~ID, data=df_all_cu)
# summary(t_ln_i_nw)

etable(fd_ln_i_nw,sn_ln_i_nw,n_ln_i_nw,t_ln_i_nw, style.tex = style.tex("aer"))

##### Panel B: 2SLS ####
c_fd_iv_nw =feols(d_EX_FD_t ~ AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t |factor(YYMM)| EIPI_t + EIPII_t + EIPIII_t ~ iEIPI_t + iEIPII_t + iEIPIII_t, 
                  cluster=~ID, data=df_all_cu)
# summary(c_fd_iv_nw)

# Strict non-durables - Just EIPt
c_sn_iv_nw =feols(d_EX_SN_t ~ AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t | factor(YYMM)| EIPI_t + EIPII_t + EIPIII_t ~ iEIPI_t + iEIPII_t + iEIPIII_t, 
                  cluster=~ID, data=df_all_cu)
# summary(c_sn_iv_nw)

# Non-durables - Just EIPt
c_n_iv_nw =feols(d_EX_N_t ~ AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t | factor(YYMM)| EIPI_t + EIPII_t + EIPIII_t ~ iEIPI_t + iEIPII_t + iEIPIII_t, 
                 cluster=~ID, data=df_all_cu)
# summary(c_n_iv_nw)

# Total - Just EIPt
c_t_iv_nw =feols(d_EX_T_t ~ AGE_AVG_t + d_NUM_ADTS_t + d_NUM_KIDS_t | factor(YYMM)| EIPI_t + EIPII_t + EIPIII_t ~ iEIPI_t + iEIPII_t + iEIPIII_t, 
                 cluster=~ID, data=df_all_cu)
# summary(c_t_iv_nw)

etable(c_fd_iv_nw,c_sn_iv_nw,c_n_iv_nw,c_t_iv_nw, style.tex = style.tex("aer"))


### Tables C.9 and C.12 ###
df_f_imp <- read_csv("df_f_imp.csv")

df_f_imp$ID <- as.double(df_f_imp$ID)

## Labeling observations as treated and untreated 
df_f_imp <- df_f_imp %>% mutate(
  tr_ob = ifelse((EIPII_t>0 | EIPII_tm1 >0 | EIPII_tm2 > 0 | EIPII_tm3 > 0), 1, 0),
  tr_ob_imp = ifelse((imp_eip2t>0 | imp_eip2tm1 >0 | imp_eip2tm2 > 0 | imp_eip2tm3 > 0), 1, 0))

# dummies
df_f_imp <- df_f_imp %>% mutate(
  iEIPI_t = ifelse(EIPI_t>0,1,0),
  iEIPII_t = ifelse(EIPII_t>0,1,0),
  iEIPIII_t = ifelse(EIPIII_t>0,1,0),
  
  
  iEIPI_tm1 = ifelse(EIPI_tm1>0,1,0),
  iEIPII_tm1 = ifelse(EIPII_tm1>0,1,0),
  iEIPIII_tm1 = ifelse(EIPIII_tm1>0,1,0),
  
  impiEIPII_t = ifelse(imp_eip2t>0,1,0),
  impiEIPII_tm1 = ifelse(imp_eip2tm1>0,1,0)
)

# Scaling 
## Food ##
df_f_sc_fd <- df_f_imp

df_f_sc_fd <- df_f_sc_fd %>% mutate(
  s_d_EX_FD_t = d_EX_FD_t / EX_FD_AVG,
  Y = s_d_EX_FD_t,
  s_AGE_AVG_t = AGE_AVG_t / EX_FD_AVG,
  s_d_NUM_ADTS_t = d_NUM_ADTS_t / EX_FD_AVG,
  s_d_NUM_KIDS_t = d_NUM_KIDS_t / EX_FD_AVG,
  
  s_EIPI_t = EIPI_t / EX_FD_AVG,
  s_EIPI_tm1 = EIPI_tm1 / EX_FD_AVG,
  s_iEIPI_t = iEIPI_t / EX_FD_AVG,
  s_iEIPI_tm1 = iEIPI_tm1 / EX_FD_AVG,
  
  s_EIPII_t = EIPII_t / EX_FD_AVG,
  s_EIPII_tm1 = EIPII_tm1 / EX_FD_AVG,
  s_iEIPII_t = iEIPII_t / EX_FD_AVG,
  s_iEIPII_tm1 = iEIPII_tm1 / EX_FD_AVG,
  
  s_EIPIII_t = EIPIII_t / EX_FD_AVG,
  s_EIPIII_tm1 = EIPIII_tm1 / EX_FD_AVG,
  s_iEIPIII_t = iEIPIII_t / EX_FD_AVG,
  s_iEIPIII_tm1 = iEIPIII_tm1 / EX_FD_AVG,
  
  s_impEIPII_t = imp_eip2t / EX_FD_AVG,
  s_impEIPII_tm1 = imp_eip2tm1 / EX_FD_AVG,
  s_impiEIPII_t = impiEIPII_t / EX_FD_AVG,
  s_impiEIPII_tm1 = impiEIPII_tm1 / EX_FD_AVG)

# Drop outliers 440798
df_f_sc_fd <- df_f_sc_fd %>% filter(ID!=440798)

# Scaling 
## Strict non-durabls ##
df_f_sc_sn <- df_f_imp

df_f_sc_sn <- df_f_sc_sn %>% mutate(
  s_d_EX_SN_t = d_EX_SN_t / EX_SN_AVG ,
  Y = s_d_EX_SN_t ,
  s_AGE_AVG_t = AGE_AVG_t / EX_SN_AVG ,
  s_d_NUM_ADTS_t = d_NUM_ADTS_t / EX_SN_AVG ,
  s_d_NUM_KIDS_t = d_NUM_KIDS_t / EX_SN_AVG ,
  
  s_EIPI_t = EIPI_t / EX_SN_AVG ,
  s_EIPI_tm1 = EIPI_tm1 / EX_SN_AVG ,
  s_iEIPI_t = iEIPI_t / EX_SN_AVG ,
  s_iEIPI_tm1 = iEIPI_tm1 / EX_SN_AVG ,
  
  s_EIPII_t = EIPII_t / EX_SN_AVG ,
  s_EIPII_tm1 = EIPII_tm1 / EX_SN_AVG ,
  s_iEIPII_t = iEIPII_t / EX_SN_AVG ,
  s_iEIPII_tm1 = iEIPII_tm1 / EX_SN_AVG ,
  
  s_EIPIII_t = EIPIII_t / EX_SN_AVG ,
  s_EIPIII_tm1 = EIPIII_tm1 / EX_SN_AVG ,
  s_iEIPIII_t = iEIPIII_t / EX_SN_AVG ,
  s_iEIPIII_tm1 = iEIPIII_tm1 / EX_SN_AVG ,
  
  s_impEIPII_t = imp_eip2t / EX_SN_AVG,
  s_impEIPII_tm1 = imp_eip2tm1 / EX_SN_AVG,
  s_impiEIPII_t = impiEIPII_t / EX_SN_AVG,
  s_impiEIPII_tm1 = impiEIPII_tm1 / EX_SN_AVG)

# Drop outliers 441555, 465865, and 466269
df_f_sc_sn <- df_f_sc_sn %>% filter(ID!=441555 & ID!=465865 & ID!=466269)

# Scaling 
## Non-durabls ##
df_f_sc_n <- df_f_imp

df_f_sc_n <- df_f_sc_n %>% mutate(
  s_d_EX_N_t = d_EX_N_t / EX_N_AVG,
  Y = s_d_EX_N_t,
  s_AGE_AVG_t = AGE_AVG_t / EX_N_AVG,
  s_d_NUM_ADTS_t = d_NUM_ADTS_t / EX_N_AVG,
  s_d_NUM_KIDS_t = d_NUM_KIDS_t / EX_N_AVG,
  
  s_EIPI_t = EIPI_t / EX_N_AVG,
  s_EIPI_tm1 = EIPI_tm1 / EX_N_AVG,
  s_iEIPI_t = iEIPI_t / EX_N_AVG,
  s_iEIPI_tm1 = iEIPI_tm1 / EX_N_AVG,
  
  s_EIPII_t = EIPII_t / EX_N_AVG,
  s_EIPII_tm1 = EIPII_tm1 / EX_N_AVG,
  s_iEIPII_t = iEIPII_t / EX_N_AVG,
  s_iEIPII_tm1 = iEIPII_tm1 / EX_N_AVG,
  
  s_EIPIII_t = EIPIII_t / EX_N_AVG,
  s_EIPIII_tm1 = EIPIII_tm1 / EX_N_AVG,
  s_iEIPIII_t = iEIPIII_t / EX_N_AVG,
  s_iEIPIII_tm1 = iEIPIII_tm1 / EX_N_AVG,
  
  s_impEIPII_t = imp_eip2t / EX_N_AVG,
  s_impEIPII_tm1 = imp_eip2tm1 / EX_N_AVG,
  s_impiEIPII_t = impiEIPII_t / EX_N_AVG,
  s_impiEIPII_tm1 = impiEIPII_tm1 / EX_N_AVG)

# Drop outliers 441555
df_f_sc_n <- df_f_sc_n %>% filter(ID!=441555)

# Scaling 
## Total expenditure ##
df_f_sc_t <- df_f_imp

df_f_sc_t <- df_f_sc_t %>% mutate(
  s_d_EX_T_t = d_EX_T_t / EX_T_AVG,
  Y = s_d_EX_T_t,
  s_AGE_AVG_t = AGE_AVG_t / EX_T_AVG,
  s_d_NUM_ADTS_t = d_NUM_ADTS_t / EX_T_AVG,
  s_d_NUM_KIDS_t = d_NUM_KIDS_t / EX_T_AVG,
  
  s_EIPI_t = EIPI_t / EX_T_AVG,
  s_EIPI_tm1 = EIPI_tm1 / EX_T_AVG,
  s_iEIPI_t = iEIPI_t / EX_T_AVG,
  s_iEIPI_tm1 = iEIPI_tm1 / EX_T_AVG,
  
  s_EIPII_t = EIPII_t / EX_T_AVG,
  s_EIPII_tm1 = EIPII_tm1 / EX_T_AVG,
  s_iEIPII_t = iEIPII_t / EX_T_AVG,
  s_iEIPII_tm1 = iEIPII_tm1 / EX_T_AVG,
  
  s_EIPIII_t = EIPIII_t / EX_T_AVG,
  s_EIPIII_tm1 = EIPIII_tm1 / EX_T_AVG,
  s_iEIPIII_t = iEIPIII_t / EX_T_AVG,
  s_iEIPIII_tm1 = iEIPIII_tm1 / EX_T_AVG,
  
  s_impEIPII_t = imp_eip2t / EX_T_AVG,
  s_impEIPII_tm1 = imp_eip2tm1 / EX_T_AVG,
  s_impiEIPII_t = impiEIPII_t / EX_T_AVG,
  s_impiEIPII_tm1 = impiEIPII_tm1 / EX_T_AVG)

# No extreme outliers

# Create datasets without imputed EIP outliers 
#   drop imp_eip2t > 3548 = (1190+3*786)
df_f_sc_fd_v2 <- df_f_sc_fd %>% filter(imp_eip2t < 3548)
df_f_sc_sn_v2 <- df_f_sc_sn %>% filter(imp_eip2t < 3548)
df_f_sc_n_v2 <- df_f_sc_n %>% filter(imp_eip2t < 3548)
df_f_sc_t_v2 <- df_f_sc_t %>% filter(imp_eip2t < 3548)

# Create copys 
df_f_sc_fd_copy <- df_f_sc_fd
df_f_sc_sn_copy <- df_f_sc_sn
df_f_sc_n_copy <- df_f_sc_n
df_f_sc_t_copy <- df_f_sc_t

df_f_sc_fd_v2_copy <- df_f_sc_fd_v2
df_f_sc_sn_v2_copy <- df_f_sc_sn_v2
df_f_sc_n_v2_copy <- df_f_sc_n_v2
df_f_sc_t_v2_copy <- df_f_sc_t_v2

imputation <- function(df){
  # Imputation with observed EIP data
  df_uno <- df %>% filter(tr_ob==0)
  
  # Step 1: Computing coefficients using only never-treated and not-yet treated units
  base <- feols(Y ~ 0 + r + s_EIPI_t + s_EIPIII_t + s_EIPI_tm1 + s_EIPIII_tm1 + s_AGE_AVG_t + s_d_NUM_ADTS_t + s_d_NUM_KIDS_t + factor(YYMM), 
                weights=~FINLWT21_AVG,cluster=~ID, data=df_uno)
  
  # Step 2: Imputing the counter-factual outcomes for all units
  df = df %>% mutate(
    coeff_r = base$coefficients[1],
    coeff_EIPI_t = base$coefficients[2],
    coeff_EIPIII_t = base$coefficients[3],
    coeff_EIPI_tm1 = base$coefficients[4],
    coeff_EIPIII_tm1 = base$coefficients[5],
    coeff_AGE = base$coefficients[6],
    coeff_ADTS = base$coefficients[7],
    coeff_KIDS = base$coefficients[8],
    YYMM_fe = ifelse(YYMM==2008,NA,
                     ifelse(YYMM==2009,base$coefficients[9],
                            ifelse(YYMM==2010,base$coefficients[10],
                                   ifelse(YYMM==2012,base$coefficients[11],
                                          ifelse(YYMM==2101,base$coefficients[12],
                                                 ifelse(YYMM==2103,base$coefficients[13],
                                                        ifelse(YYMM==2104,base$coefficients[14],
                                                               ifelse(YYMM==2106,base$coefficients[15],
                                                                      ifelse(YYMM==2107,base$coefficients[16],
                                                                             ifelse(YYMM==2109,base$coefficients[17],base$coefficients[18])))))))))),
    
    Y_0 = coeff_r * r + coeff_EIPI_t * s_EIPI_t + coeff_EIPIII_t * s_EIPIII_t + 
      coeff_EIPI_tm1 * s_EIPI_tm1 + coeff_EIPIII_tm1 * s_EIPIII_tm1 + 
      coeff_AGE * s_AGE_AVG_t + coeff_ADTS * s_d_NUM_ADTS_t + coeff_KIDS * s_d_NUM_KIDS_t + YYMM_fe,
    
    # Step 3: Differencing the counter-factual from the observed outcome
    
    Y_new = Y - Y_0)
  
  # Imputation with imputed EIP data
  df_uno_imp <- df %>% filter(tr_ob_imp==0)
  
  # Step 1: Computing coefficients using only never-treated and not-yet treated units
  base_imp <- feols(Y ~ 0 + r + s_EIPI_t + s_EIPIII_t + s_EIPI_tm1 + s_EIPIII_tm1 + s_AGE_AVG_t + s_d_NUM_ADTS_t + s_d_NUM_KIDS_t + factor(YYMM), 
                    weights=~FINLWT21_AVG,cluster=~ID, data=df_uno_imp)
  
  # Step 2: Imputing the counter-factual outcomes for all units
  df = df %>% mutate(
    coeff_r_imp = base_imp$coefficients[1],
    coeff_EIPI_t_imp = base_imp$coefficients[2],
    coeff_EIPIII_t_imp = base_imp$coefficients[3],
    coeff_EIPI_tm1_imp = base_imp$coefficients[4],
    coeff_EIPIII_tm1_imp = base_imp$coefficients[5],
    coeff_AGE_imp = base_imp$coefficients[6],
    coeff_ADTS_imp = base_imp$coefficients[7],
    coeff_KIDS_imp = base_imp$coefficients[8],
    YYMM_fe_imp = ifelse(YYMM==2008,NA,
                         ifelse(YYMM==2009,base_imp$coefficients[9],
                                ifelse(YYMM==2010,base_imp$coefficients[10],
                                       ifelse(YYMM==2012,base_imp$coefficients[11],
                                              ifelse(YYMM==2101,base_imp$coefficients[12],
                                                     ifelse(YYMM==2103,base_imp$coefficients[13],
                                                            ifelse(YYMM==2104,base_imp$coefficients[14],
                                                                   ifelse(YYMM==2106,base_imp$coefficients[15],
                                                                          ifelse(YYMM==2107,base_imp$coefficients[16],
                                                                                 ifelse(YYMM==2109,base_imp$coefficients[17],base_imp$coefficients[18])))))))))),
    
    Y_0_imp = coeff_r_imp * r + coeff_EIPI_t_imp * s_EIPI_t + coeff_EIPIII_t_imp * s_EIPIII_t + 
      coeff_EIPI_tm1_imp * s_EIPI_tm1 + coeff_EIPIII_tm1_imp * s_EIPIII_tm1 + 
      coeff_AGE_imp * s_AGE_AVG_t + coeff_ADTS_imp * s_d_NUM_ADTS_t + coeff_KIDS_imp * s_d_NUM_KIDS_t + YYMM_fe_imp,
    
    # Step 3: Differencing the counter-factual from the observed outcome
    
    Y_new_imp = Y - Y_0_imp)
  
  return(df)
}

df_f_sc_fd <- imputation(df_f_sc_fd_copy) # Y is s_d_EX_FD
df_f_sc_fd_obs <- df_f_sc_fd %>% filter(tr_ob==1) 
df_f_sc_fd_imp <- df_f_sc_fd %>% filter(tr_ob_imp==1)

df_f_sc_sn <- imputation(df_f_sc_sn_copy) # Y is s_d_EX_SN
df_f_sc_sn_obs <- df_f_sc_sn %>% filter(tr_ob==1) 
df_f_sc_sn_imp <- df_f_sc_sn %>% filter(tr_ob_imp==1)

df_f_sc_n <- imputation(df_f_sc_n_copy) # Y is s_d_EX_N
df_f_sc_n_obs <- df_f_sc_n %>% filter(tr_ob==1) 
df_f_sc_n_imp <- df_f_sc_n %>% filter(tr_ob_imp==1)

df_f_sc_t <- imputation(df_f_sc_t_copy) # Y is s_d_EX_T
df_f_sc_t_obs <- df_f_sc_t %>% filter(tr_ob==1) 
df_f_sc_t_imp <- df_f_sc_t %>% filter(tr_ob_imp==1)

df_f_sc_fd_v2 <- imputation(df_f_sc_fd_v2_copy) # Y is s_d_EX_FD
df_f_sc_fd_v2_imp <- df_f_sc_fd_v2 %>% filter(tr_ob_imp==1) 

df_f_sc_sn_v2 <- imputation(df_f_sc_sn_v2_copy) # Y is s_d_EX_SN
df_f_sc_sn_v2_imp <- df_f_sc_sn_v2 %>% filter(tr_ob_imp==1) 

df_f_sc_n_v2 <- imputation(df_f_sc_n_v2_copy) # Y is s_d_EX_N
df_f_sc_n_v2_imp <- df_f_sc_n_v2 %>% filter(tr_ob_imp==1) 

df_f_sc_t_v2 <- imputation(df_f_sc_t_v2_copy) # Y is s_d_EX_T
df_f_sc_t_v2_imp <- df_f_sc_t_v2 %>% filter(tr_ob_imp==1) 

##### Normalized level change - Normalized EIPII amount ####

# Food
n_w_fd_cle_le_to <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                          weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd_obs)

imp_n_w_fd_cle_le_to <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                              weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd_imp)

imp_n_w_fd_cle_le_to_v2 <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                                 weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd_v2_imp)
# summary(n_w_fd_cle_le_to)

# Strictly non-durables
n_w_sn_cle_le_to <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                          weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn_obs)

imp_n_w_sn_cle_le_to <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                              weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn_imp)

imp_n_w_sn_cle_le_to_v2 <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                                 weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn_v2_imp)
# summary(n_w_sn_cle_le_to)

# Non-durables
n_w_n_cle_le_to <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                         weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n_obs)

imp_n_w_n_cle_le_to <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                             weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n_imp)

imp_n_w_n_cle_le_to_v2 <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                                weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n_v2_imp)
# summary(n_w_n_cle_le_to)

# Total
n_w_t_cle_le_to <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                         weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t_obs)

imp_n_w_t_cle_le_to <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                             weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t_imp)

imp_n_w_t_cle_le_to_v2 <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                                weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t_v2_imp)
# summary(n_w_t_cle_le_to)

etable(n_w_fd_cle_le_to,n_w_sn_cle_le_to,n_w_n_cle_le_to,n_w_t_cle_le_to, style.tex = style.tex("aer"))
etable(imp_n_w_fd_cle_le_to,imp_n_w_sn_cle_le_to,imp_n_w_n_cle_le_to,imp_n_w_t_cle_le_to, style.tex = style.tex("aer"))
etable(imp_n_w_fd_cle_le_to_v2,imp_n_w_sn_cle_le_to_v2,imp_n_w_n_cle_le_to_v2,imp_n_w_t_cle_le_to_v2, style.tex = style.tex("aer"))

##### Panel B: Normalized level change - Normalized EIPII indicator ####
imputation_i <- function(df){
  # Imputation with observed EIP data
  df_uno <- df %>% filter(tr_ob==0)
  
  # Step 1: Computing coefficients using only never-treated and not-yet treated units
  base <- feols(Y ~ 0 + r + s_iEIPI_t + s_iEIPIII_t + s_iEIPI_tm1 + s_iEIPIII_tm1 + s_AGE_AVG_t + s_d_NUM_ADTS_t + s_d_NUM_KIDS_t + factor(YYMM), 
                weights=~FINLWT21_AVG,cluster=~ID, data=df_uno)
  
  # Step 2: Imputing the counter-factual outcomes for all units
  
  df = df %>% mutate(
    coeff_r = base$coefficients[1],
    coeff_EIPI_t = base$coefficients[2],
    coeff_EIPIII_t = base$coefficients[3],
    coeff_EIPI_tm1 = base$coefficients[4],
    coeff_EIPIII_tm1 = base$coefficients[5],
    coeff_AGE = base$coefficients[6],
    coeff_ADTS = base$coefficients[7],
    coeff_KIDS = base$coefficients[8],
    YYMM_fe = ifelse(YYMM==2008,NA,
                     ifelse(YYMM==2009,base$coefficients[9],
                            ifelse(YYMM==2010,base$coefficients[10],
                                   ifelse(YYMM==2012,base$coefficients[11],
                                          ifelse(YYMM==2101,base$coefficients[12],
                                                 ifelse(YYMM==2103,base$coefficients[13],
                                                        ifelse(YYMM==2104,base$coefficients[14],
                                                               ifelse(YYMM==2106,base$coefficients[15],
                                                                      ifelse(YYMM==2107,base$coefficients[16],
                                                                             ifelse(YYMM==2109,base$coefficients[17],base$coefficients[18])))))))))),
    
    Y_0 = coeff_r * r + coeff_EIPI_t * s_iEIPI_t + coeff_EIPIII_t * s_iEIPIII_t + 
      coeff_EIPI_tm1 * s_iEIPI_tm1 + coeff_EIPIII_tm1 * s_iEIPIII_tm1 +
      coeff_AGE * s_AGE_AVG_t + coeff_ADTS * s_d_NUM_ADTS_t + coeff_KIDS * s_d_NUM_KIDS_t + YYMM_fe,
    
    # Step 3: Differencing the counter-factual from the observed outcome
    
    Y_new = Y - Y_0)
  
  # Imputation with imputed EIP data
  df_uno_imp <- df %>% filter(tr_ob_imp==0)
  
  # Step 1: Computing coefficients using only never-treated and not-yet treated units
  base_imp <- feols(Y ~ 0 + r + s_iEIPI_t + s_iEIPIII_t + s_iEIPI_tm1 + s_iEIPIII_tm1 + s_AGE_AVG_t + s_d_NUM_ADTS_t + s_d_NUM_KIDS_t + factor(YYMM), 
                    weights=~FINLWT21_AVG,cluster=~ID, data=df_uno_imp)
  
  # Step 2: Imputing the counter-factual outcomes for all units
  
  df = df %>% mutate(
    coeff_r_imp = base_imp$coefficients[1],
    coeff_EIPI_t_imp = base_imp$coefficients[2],
    coeff_EIPIII_t_imp = base_imp$coefficients[3],
    coeff_EIPI_tm1_imp = base_imp$coefficients[4],
    coeff_EIPIII_tm1_imp = base_imp$coefficients[5],
    coeff_AGE_imp = base_imp$coefficients[6],
    coeff_ADTS_imp = base_imp$coefficients[7],
    coeff_KIDS_imp = base_imp$coefficients[8],
    YYMM_fe_imp = ifelse(YYMM==2008,NA,
                         ifelse(YYMM==2009,base_imp$coefficients[9],
                                ifelse(YYMM==2010,base_imp$coefficients[10],
                                       ifelse(YYMM==2012,base_imp$coefficients[11],
                                              ifelse(YYMM==2101,base_imp$coefficients[12],
                                                     ifelse(YYMM==2103,base_imp$coefficients[13],
                                                            ifelse(YYMM==2104,base_imp$coefficients[14],
                                                                   ifelse(YYMM==2106,base_imp$coefficients[15],
                                                                          ifelse(YYMM==2107,base_imp$coefficients[16],
                                                                                 ifelse(YYMM==2109,base_imp$coefficients[17],base_imp$coefficients[18])))))))))),
    
    Y_0_imp = coeff_r_imp * r + coeff_EIPI_t_imp * s_iEIPI_t + coeff_EIPIII_t_imp * s_iEIPIII_t + 
      coeff_EIPI_tm1_imp * s_iEIPI_tm1 + coeff_EIPIII_tm1_imp * s_iEIPIII_tm1 +
      coeff_AGE_imp * s_AGE_AVG_t + coeff_ADTS_imp * s_d_NUM_ADTS_t + coeff_KIDS_imp * s_d_NUM_KIDS_t + YYMM_fe_imp,
    
    # Step 3: Differencing the counter-factual from the observed outcome
    
    Y_new_imp = Y - Y_0_imp)
  
  return(df)
}

df_f_sc_fd <- imputation_i(df_f_sc_fd_copy) # Y is s_d_EX_FD
df_f_sc_fd_obs <- df_f_sc_fd %>% filter(tr_ob==1)
df_f_sc_fd_imp <- df_f_sc_fd %>% filter(tr_ob_imp==1) 

df_f_sc_sn <- imputation_i(df_f_sc_sn_copy) # Y is s_d_EX_SN
df_f_sc_sn_obs <- df_f_sc_sn %>% filter(tr_ob==1) 
df_f_sc_sn_imp <- df_f_sc_sn %>% filter(tr_ob_imp==1)

df_f_sc_n <- imputation_i(df_f_sc_n_copy) # Y is s_d_EX_N
df_f_sc_n_obs <- df_f_sc_n %>% filter(tr_ob==1) 
df_f_sc_n_imp <- df_f_sc_n %>% filter(tr_ob_imp==1) 

df_f_sc_t <- imputation_i(df_f_sc_t_copy) # Y is s_d_EX_T
df_f_sc_t_obs <- df_f_sc_t %>% filter(tr_ob==1) 
df_f_sc_t_imp <- df_f_sc_t %>% filter(tr_ob_imp==1) 

df_f_sc_fd_v2 <- imputation_i(df_f_sc_fd_v2_copy) # Y is s_d_EX_FD
df_f_sc_fd_v2_imp <- df_f_sc_fd_v2 %>% filter(tr_ob_imp==1) 

df_f_sc_sn_v2 <- imputation_i(df_f_sc_sn_v2_copy) # Y is s_d_EX_SN
df_f_sc_sn_v2_imp <- df_f_sc_sn_v2 %>% filter(tr_ob_imp==1) 

df_f_sc_n_v2 <- imputation_i(df_f_sc_n_v2_copy) # Y is s_d_EX_N
df_f_sc_n_v2_imp <- df_f_sc_n_v2 %>% filter(tr_ob_imp==1) 

df_f_sc_t_v2 <- imputation_i(df_f_sc_t_v2_copy) # Y is s_d_EX_T
df_f_sc_t_v2_imp <- df_f_sc_t_v2 %>% filter(tr_ob_imp==1)

# Food
n_w_fd_cle_i_to <- feols(Y_new ~ s_iEIPII_t + s_iEIPII_tm1, 
                         weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd_obs)

imp_n_w_fd_cle_i_to <- feols(Y_new_imp ~ s_impiEIPII_t + s_impiEIPII_tm1, 
                             weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd_imp)

imp_n_w_fd_cle_i_to_v2 <- feols(Y_new_imp ~ s_impiEIPII_t + s_impiEIPII_tm1, 
                                weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd_v2_imp)
# summary(n_w_fd_cle_i_to)

# Strictly non-durables
n_w_sn_cle_i_to <- feols(Y_new ~ s_iEIPII_t + s_iEIPII_tm1, 
                         weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn_obs)

imp_n_w_sn_cle_i_to <- feols(Y_new_imp ~ s_impiEIPII_t + s_impiEIPII_tm1, 
                             weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn_imp)

imp_n_w_sn_cle_i_to_v2 <- feols(Y_new_imp ~ s_impiEIPII_t + s_impiEIPII_tm1, 
                                weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn_v2_imp)
# summary(n_w_sn_cle_i_to)

# Non-durables
n_w_n_cle_i_to <- feols(Y_new ~ s_iEIPII_t + s_iEIPII_tm1, 
                        weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n_obs)

imp_n_w_n_cle_i_to <- feols(Y_new_imp ~ s_impiEIPII_t + s_impiEIPII_tm1, 
                            weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n_imp)

imp_n_w_n_cle_i_to_v2 <- feols(Y_new_imp ~ s_impiEIPII_t + s_impiEIPII_tm1, 
                               weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n_v2_imp)
# summary(n_w_n_cle_i_to)

# Total
n_w_t_cle_i_to <- feols(Y_new ~ s_iEIPII_t + s_iEIPII_tm1, 
                        weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t_obs)

imp_n_w_t_cle_i_to <- feols(Y_new_imp ~ s_impiEIPII_t + s_impiEIPII_tm1, 
                            weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t_imp)

imp_n_w_t_cle_i_to_v2 <- feols(Y_new_imp ~ s_impiEIPII_t + s_impiEIPII_tm1, 
                               weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t_v2_imp)
# summary(n_w_t_cle_i_to)

etable(n_w_fd_cle_i_to,n_w_sn_cle_i_to,n_w_n_cle_i_to,n_w_t_cle_i_to, style.tex = style.tex("aer"))
etable(imp_n_w_fd_cle_i_to,imp_n_w_sn_cle_i_to,imp_n_w_n_cle_i_to,imp_n_w_t_cle_i_to, style.tex = style.tex("aer"))
etable(imp_n_w_fd_cle_i_to_v2,imp_n_w_sn_cle_i_to_v2,imp_n_w_n_cle_i_to_v2,imp_n_w_t_cle_i_to_v2, style.tex = style.tex("aer"))

### Table IV ####

imputation <- function(df){
  # Imputation with observed EIP data
  df_uno <- df %>% filter(tr_ob==0)
  
  # Step 1: Computing coefficients using only never-treated and not-yet treated units
  base <- feols(Y ~ 0 + r + s_EIPI_t + s_EIPIII_t + s_EIPI_tm1 + s_EIPIII_tm1 + s_AGE_AVG_t + s_d_NUM_ADTS_t + s_d_NUM_KIDS_t + factor(YYMM), 
                weights=~FINLWT21_AVG,cluster=~ID, data=df_uno)
  
  # Step 2: Imputing the counter-factual outcomes for all units
  df = df %>% mutate(
    coeff_r = base$coefficients[1],
    coeff_EIPI_t = base$coefficients[2],
    coeff_EIPIII_t = base$coefficients[3],
    coeff_EIPI_tm1 = base$coefficients[4],
    coeff_EIPIII_tm1 = base$coefficients[5],
    coeff_AGE = base$coefficients[6],
    coeff_ADTS = base$coefficients[7],
    coeff_KIDS = base$coefficients[8],
    YYMM_fe = ifelse(YYMM==2008,NA,
                     ifelse(YYMM==2009,base$coefficients[9],
                            ifelse(YYMM==2010,base$coefficients[10],
                                   ifelse(YYMM==2012,base$coefficients[11],
                                          ifelse(YYMM==2101,base$coefficients[12],
                                                 ifelse(YYMM==2103,base$coefficients[13],
                                                        ifelse(YYMM==2104,base$coefficients[14],
                                                               ifelse(YYMM==2106,base$coefficients[15],
                                                                      ifelse(YYMM==2107,base$coefficients[16],
                                                                             ifelse(YYMM==2109,base$coefficients[17],base$coefficients[18])))))))))),
    
    Y_0 = coeff_r * r + coeff_EIPI_t * s_EIPI_t + coeff_EIPIII_t * s_EIPIII_t + 
      coeff_EIPI_tm1 * s_EIPI_tm1 + coeff_EIPIII_tm1 * s_EIPIII_tm1 + 
      coeff_AGE * s_AGE_AVG_t + coeff_ADTS * s_d_NUM_ADTS_t + coeff_KIDS * s_d_NUM_KIDS_t + YYMM_fe,
    
    # Step 3: Differencing the counter-factual from the observed outcome
    
    Y_new = Y - Y_0)
  
  # Imputation with imputed EIP data
  df_uno_imp <- df %>% filter(tr_ob_imp==0)
  
  # Step 1: Computing coefficients using only never-treated and not-yet treated units
  base_imp <- feols(Y ~ 0 + r + s_EIPI_t + s_EIPIII_t + s_EIPI_tm1 + s_EIPIII_tm1 + s_AGE_AVG_t + s_d_NUM_ADTS_t + s_d_NUM_KIDS_t + factor(YYMM), 
                    weights=~FINLWT21_AVG,cluster=~ID, data=df_uno_imp)
  
  # Step 2: Imputing the counter-factual outcomes for all units
  df = df %>% mutate(
    coeff_r_imp = base_imp$coefficients[1],
    coeff_EIPI_t_imp = base_imp$coefficients[2],
    coeff_EIPIII_t_imp = base_imp$coefficients[3],
    coeff_EIPI_tm1_imp = base_imp$coefficients[4],
    coeff_EIPIII_tm1_imp = base_imp$coefficients[5],
    coeff_AGE_imp = base_imp$coefficients[6],
    coeff_ADTS_imp = base_imp$coefficients[7],
    coeff_KIDS_imp = base_imp$coefficients[8],
    YYMM_fe_imp = ifelse(YYMM==2008,NA,
                         ifelse(YYMM==2009,base_imp$coefficients[9],
                                ifelse(YYMM==2010,base_imp$coefficients[10],
                                       ifelse(YYMM==2012,base_imp$coefficients[11],
                                              ifelse(YYMM==2101,base_imp$coefficients[12],
                                                     ifelse(YYMM==2103,base_imp$coefficients[13],
                                                            ifelse(YYMM==2104,base_imp$coefficients[14],
                                                                   ifelse(YYMM==2106,base_imp$coefficients[15],
                                                                          ifelse(YYMM==2107,base_imp$coefficients[16],
                                                                                 ifelse(YYMM==2109,base_imp$coefficients[17],base_imp$coefficients[18])))))))))),
    
    Y_0_imp = coeff_r_imp * r + coeff_EIPI_t_imp * s_EIPI_t + coeff_EIPIII_t_imp * s_EIPIII_t + 
      coeff_EIPI_tm1_imp * s_EIPI_tm1 + coeff_EIPIII_tm1_imp * s_EIPIII_tm1 + 
      coeff_AGE_imp * s_AGE_AVG_t + coeff_ADTS_imp * s_d_NUM_ADTS_t + coeff_KIDS_imp * s_d_NUM_KIDS_t + YYMM_fe_imp,
    
    # Step 3: Differencing the counter-factual from the observed outcome
    
    Y_new_imp = Y - Y_0_imp)
  
  return(df)
}

df_f_sc_fd <- imputation(df_f_sc_fd_copy) # Y is s_d_EX_FD
df_f_sc_fd_obs <- df_f_sc_fd %>% filter(tr_ob==1) 
df_f_sc_fd_imp <- df_f_sc_fd %>% filter(tr_ob_imp==1)

df_f_sc_sn <- imputation(df_f_sc_sn_copy) # Y is s_d_EX_SN
df_f_sc_sn_obs <- df_f_sc_sn %>% filter(tr_ob==1) 
df_f_sc_sn_imp <- df_f_sc_sn %>% filter(tr_ob_imp==1)

df_f_sc_n <- imputation(df_f_sc_n_copy) # Y is s_d_EX_N
df_f_sc_n_obs <- df_f_sc_n %>% filter(tr_ob==1) 
df_f_sc_n_imp <- df_f_sc_n %>% filter(tr_ob_imp==1)

df_f_sc_t <- imputation(df_f_sc_t_copy) # Y is s_d_EX_T
df_f_sc_t_obs <- df_f_sc_t %>% filter(tr_ob==1) 
df_f_sc_t_imp <- df_f_sc_t %>% filter(tr_ob_imp==1)

df_f_sc_fd_v2 <- imputation(df_f_sc_fd_v2_copy) # Y is s_d_EX_FD
df_f_sc_fd_v2_imp <- df_f_sc_fd_v2 %>% filter(tr_ob_imp==1) 

df_f_sc_sn_v2 <- imputation(df_f_sc_sn_v2_copy) # Y is s_d_EX_SN
df_f_sc_sn_v2_imp <- df_f_sc_sn_v2 %>% filter(tr_ob_imp==1) 

df_f_sc_n_v2 <- imputation(df_f_sc_n_v2_copy) # Y is s_d_EX_N
df_f_sc_n_v2_imp <- df_f_sc_n_v2 %>% filter(tr_ob_imp==1) 

df_f_sc_t_v2 <- imputation(df_f_sc_t_v2_copy) # Y is s_d_EX_T
df_f_sc_t_v2_imp <- df_f_sc_t_v2 %>% filter(tr_ob_imp==1) 

##### WLS ####
# Food
n_w_fd_cle_le <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                       weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd_obs)

imp_n_w_fd_cle_le <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                           weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd_imp)

imp_n_w_fd_cle_le_v2 <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                              weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_fd_v2_imp)
# summary(n_w_fd_cle_le)

# Strictly non-durables 
n_w_sn_cle_le <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                       weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn_obs)

imp_n_w_sn_cle_le <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                           weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn_imp)

imp_n_w_sn_cle_le_v2 <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                              weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_sn_v2_imp)
# summary(n_w_sn_cle_le)

# Non-durables 
n_w_n_cle_le <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1,
                      weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n_obs)

imp_n_w_n_cle_le <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1,
                          weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n_imp)

imp_n_w_n_cle_le_v2 <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1,
                             weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_n_v2_imp)
# summary(n_w_n_cle_le)

# Total
n_w_t_cle_le <- feols(Y_new ~ s_EIPII_t + s_EIPII_tm1, 
                      weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t_obs)

imp_n_w_t_cle_le <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                          weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t_imp)

imp_n_w_t_cle_le_v2 <- feols(Y_new_imp ~ s_impEIPII_t + s_impEIPII_tm1, 
                             weights=~FINLWT21_AVG,cluster=~ID, data=df_f_sc_t_v2_imp)
# summary(n_w_t_cle_le)

etable(n_w_sn_cle_le,n_w_n_cle_le,n_w_t_cle_le, style.tex = style.tex("aer"))
etable(imp_n_w_sn_cle_le,imp_n_w_n_cle_le,imp_n_w_t_cle_le, style.tex = style.tex("aer"))
etable(imp_n_w_sn_cle_le_v2,imp_n_w_n_cle_le_v2,imp_n_w_t_cle_le_v2, style.tex = style.tex("aer"))

# Cumulative amount
deltaMethod(n_w_sn_cle_le, "s_EIPII_t+s_EIPII_t+s_EIPII_tm1",vcov.=vcov(n_w_sn_cle_le))
deltaMethod(n_w_n_cle_le, "s_EIPII_t+s_EIPII_t+s_EIPII_tm1",vcov.=vcov(n_w_n_cle_le))
deltaMethod(n_w_t_cle_le, "s_EIPII_t+s_EIPII_t+s_EIPII_tm1",vcov.=vcov(n_w_t_cle_le))

deltaMethod(imp_n_w_sn_cle_le, "s_impEIPII_t+s_impEIPII_t+s_impEIPII_tm1",vcov.=vcov(imp_n_w_sn_cle_le))
deltaMethod(imp_n_w_n_cle_le, "s_impEIPII_t+s_impEIPII_t+s_impEIPII_tm1",vcov.=vcov(imp_n_w_n_cle_le))
deltaMethod(imp_n_w_t_cle_le, "s_impEIPII_t+s_impEIPII_t+s_impEIPII_tm1",vcov.=vcov(imp_n_w_t_cle_le))

deltaMethod(imp_n_w_sn_cle_le_v2, "s_impEIPII_t+s_impEIPII_t+s_impEIPII_tm1",vcov.=vcov(imp_n_w_sn_cle_le_v2))
deltaMethod(imp_n_w_n_cle_le_v2, "s_impEIPII_t+s_impEIPII_t+s_impEIPII_tm1",vcov.=vcov(imp_n_w_n_cle_le_v2))
deltaMethod(imp_n_w_t_cle_le_v2, "s_impEIPII_t+s_impEIPII_t+s_impEIPII_tm1",vcov.=vcov(imp_n_w_t_cle_le_v2))